/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.dptools;

import java.util.UUID;
import org.freeswitch.esl.client.dptools.ExecuteException;
import org.freeswitch.esl.client.internal.IModEslApi;
import org.freeswitch.esl.client.transport.CommandResponse;
import org.freeswitch.esl.client.transport.SendMsg;
import org.freeswitch.esl.client.transport.message.EslMessage;

public class Execute {
    IModEslApi api;
    String _uuid;

    public Execute(IModEslApi api, String uuid) {
        this.api = api;
        this._uuid = uuid;
    }

    public void sendDiplay(String message) throws ExecuteException {
        this.sendExeMesg("send_display", message);
    }

    public void answer() throws ExecuteException {
        this.sendExeMesg("answer");
    }

    public void attAnswer(String channelUrl) throws ExecuteException {
        this.sendExeMesg("att_xfer", channelUrl);
    }

    public void bindMetaApp(String key, String leg, String flags, String application, String params) throws ExecuteException {
        this.sendExeMesg("bind_meta_app", key + " " + leg + flags + " " + application + "::" + params);
    }

    public void breakChannel(boolean all) throws ExecuteException {
        this.sendExeMesg("break", all ? "all" : "");
    }

    public void bridge(String endpoint) throws ExecuteException {
        this.sendExeMesg("bridge", endpoint);
    }

    public void bridgeExport(String key, String value, boolean local) throws ExecuteException {
        StringBuilder sb = new StringBuilder();
        if (!local) {
            sb.append("nolocal:");
        }
        sb.append(key);
        sb.append("=");
        sb.append(value);
        this.sendExeMesg("bridge_export", sb.toString());
    }

    public void chat(String proto, String from, String to, String message) throws ExecuteException {
        this.sendExeMesg("chat", proto + "|" + from + "|" + to + "|" + message);
    }

    public void cngPlc() throws ExecuteException {
        this.sendExeMesg("cng_plc");
    }

    public void conference(String name) throws ExecuteException {
        this.conference(name, null, null, null);
    }

    public void conference(String name, String profile) throws ExecuteException {
        this.conference(name, profile, null, null);
    }

    public void conference(String name, String profile, String pin) throws ExecuteException {
        this.conference(name, profile, pin, null);
    }

    public void conference(String name, String profile, String pin, String flags) throws ExecuteException {
        StringBuilder sb = new StringBuilder(name);
        if (this.nn(profile)) {
            sb.append("@").append(profile);
        }
        if (this.nn(pin)) {
            sb.append("+").append(pin);
        }
        if (this.nn(flags)) {
            sb.append("+flags{").append(flags).append("}");
        }
        this.sendExeMesg("conference", sb.toString());
    }

    public void deflect(String endpoint) throws ExecuteException {
        this.sendExeMesg("deflect", endpoint);
    }

    public void delayEcho(long ms) throws ExecuteException {
        this.sendExeMesg("delay_echo", ms + "");
    }

    public void detectSpeech(String args) throws ExecuteException {
        this.sendExeMesg("detect_speech", args);
    }

    public void displaceSession(String path) throws ExecuteException {
        this.displaceSession(path, null, 0L);
    }

    public void displaceSession(String path, String flags) throws ExecuteException {
        this.displaceSession(path, flags, 0L);
    }

    public void displaceSession(String path, String flags, long timeLimitMillis) throws ExecuteException {
        StringBuilder sb = new StringBuilder(path);
        if (this.nn(flags)) {
            sb.append(" ").append(flags);
        }
        if (timeLimitMillis > 0L) {
            sb.append(" +").append(timeLimitMillis);
        }
        this.sendExeMesg("displace_session", sb.toString());
    }

    public void eavesdrop(String uuid) throws ExecuteException {
        this.eavesdrop(uuid, false, null, null, null, null);
    }

    public void eavesdrop(String uuid, boolean enableDTMF) throws ExecuteException {
        this.eavesdrop(uuid, enableDTMF, null, null, null, null);
    }

    public void eavesdrop(String uuid, boolean enableDTMF, String groupId) throws ExecuteException {
        this.eavesdrop(uuid, enableDTMF, groupId, null, null, null);
    }

    public void eavesdrop(String uuid, boolean enableDTMF, String groupId, String failedWav) throws ExecuteException {
        this.eavesdrop(uuid, enableDTMF, groupId, failedWav, null, null);
    }

    public void eavesdrop(String uuid, boolean enableDTMF, String groupId, String failedWav, String newChannelWav) throws ExecuteException {
        this.eavesdrop(uuid, enableDTMF, groupId, failedWav, newChannelWav, null);
    }

    public void eavesdrop(String uuid, boolean enableDTMF, String groupId, String failedWav, String newChannelWav, String idleWav) throws ExecuteException {
        if (this.nn(groupId)) {
            this.set("eavesdrop_require_group", groupId);
        }
        if (this.nn(failedWav)) {
            this.set("eavesdrop_indicate_failed", failedWav);
        }
        if (this.nn(newChannelWav)) {
            this.set("eavesdrop_indicate_new", newChannelWav);
        }
        if (this.nn(idleWav)) {
            this.set("eavesdrop_indicate_idle", idleWav);
        }
        this.set("eavesdrop_enable_dtmf", String.valueOf(enableDTMF));
        this.sendExeMesg("eavesdrop", uuid);
    }

    public void echo() throws ExecuteException {
        this.sendExeMesg("echo");
    }

    public void endlessPlayback(String file) throws ExecuteException {
        this.sendExeMesg("endless_playback", file);
    }

    public void eval(String string) throws ExecuteException {
        this.sendExeMesg("eval", string);
    }

    public void event(String event) throws ExecuteException {
        this.sendExeMesg("event", event);
    }

    public void executeExtension(String extension) throws ExecuteException {
        this.executeExtension(extension, null, null);
    }

    public void executeExtension(String extension, String dialplan) throws ExecuteException {
        this.executeExtension(extension, dialplan, null);
    }

    public void executeExtension(String extension, String dialplan, String context) throws ExecuteException {
        StringBuilder sb = new StringBuilder(extension);
        if (this.nn(dialplan)) {
            sb.append(" ").append(dialplan);
            if (this.nn(context)) {
                sb.append(" ").append(context);
            }
        }
        this.sendExeMesg("execute_extension", sb.toString());
    }

    public void export(String key, String value, boolean local) throws ExecuteException {
        StringBuilder sb = new StringBuilder();
        if (!local) {
            sb.append("nolocal:");
        }
        sb.append(key);
        sb.append("=");
        sb.append(value);
        this.sendExeMesg("export", sb.toString());
    }

    public void faxDetect(String context, String ext) throws ExecuteException {
        this.sendExeMesg("tone_detect", "fax 1100 r +5000 transfer " + ext + " XML " + context);
    }

    public void flushDTMF() throws ExecuteException {
        this.sendExeMesg("flush_dtmf");
    }

    public void gentones(String tone) throws ExecuteException {
        this.gentones(tone, 0);
    }

    public void gentones(String tone, int loops) throws ExecuteException {
        this.sendExeMesg("gentones", tone + (loops != 0 ? "|" + loops : ""));
    }

    public void group(String action, String groupName, String url) throws ExecuteException {
        this.sendExeMesg("group", action + ":" + groupName + ":" + url);
    }

    public void hangup() throws ExecuteException {
        this.sendExeMesg("hangup", null);
    }

    public void hangup(String reason) throws ExecuteException {
        this.sendExeMesg("hangup", reason);
    }

    public void info() throws ExecuteException {
        this.sendExeMesg("info", null);
    }

    public void info(String level) throws ExecuteException {
        this.sendExeMesg("info", level);
    }

    public void intercept(String uuid, boolean bleg) throws ExecuteException {
        this.sendExeMesg("intercept", (bleg ? "-bleg " : "") + uuid);
    }

    public void log(String message) throws ExecuteException {
        this.log(null, message);
    }

    public void log(String level, String message) throws ExecuteException {
        this.sendExeMesg("log", (this.nn(level) ? level + " " : "") + message);
    }

    public void mkdir(String path) throws ExecuteException {
        this.sendExeMesg("mkdir", path);
    }

    public void park() throws ExecuteException {
        this.sendExeMesg("park");
    }

    public void phrase(String macroName, String data) throws ExecuteException {
        this.sendExeMesg("phrase", macroName + "," + data);
    }

    public void pickup(String group) throws ExecuteException {
        this.sendExeMesg("pickup", group);
    }

    public String playAndDetectSpeech(String file, String engine, String grammer) throws ExecuteException {
        return this.playAndDetectSpeech(file, engine, null, grammer);
    }

    public String playAndDetectSpeech(String file, String engine, String grammer, String params) throws ExecuteException {
        CommandResponse resp = this.sendExeMesg("play_and_detect_speech", file + " detect:" + engine + " {" + (this.nn(params) ? params : "") + "}" + grammer);
        if (resp.isOk()) {
            EslMessage eslMessage = this.api.sendApiCommand("uuid_getvar", this._uuid + " detect_speech_result");
            if (eslMessage.getBodyLines().size() > 0) {
                return eslMessage.getBodyLines().get(0);
            }
        } else {
            throw new ExecuteException(resp.getReplyText());
        }
        return null;
    }

    public String playAndGetDigits(int min, int max, int tries, int timeout, String terminator, String file, String invalidFile, String regexp, int digitTimeout) throws ExecuteException {
        String id = UUID.randomUUID().toString();
        CommandResponse resp = this.sendExeMesg("play_and_get_digits", String.valueOf(min) + " " + max + " " + tries + " " + timeout + " " + terminator + " " + file + " " + invalidFile + " " + id + " " + regexp + " " + digitTimeout);
        if (resp.isOk()) {
            EslMessage eslMessage = this.api.sendApiCommand("uuid_getvar", this._uuid + " " + id);
            if (eslMessage.getBodyLines().size() > 0) {
                return eslMessage.getBodyLines().get(0);
            }
        } else {
            throw new ExecuteException(resp.getReplyText());
        }
        return null;
    }

    public void playback(String file) throws ExecuteException {
        this.playback(file, null);
    }

    public void playback(String file, String data) throws ExecuteException {
        StringBuilder sb = new StringBuilder(file);
        if (this.nn(data)) {
            sb.append(" {");
            sb.append(data);
            sb.append("}");
        }
        this.sendExeMesg("playback", sb.toString());
    }

    public void playbackSpeed(int step) throws ExecuteException {
        this.playbackControl("speed " + step);
    }

    public void playbackVolume(int step) throws ExecuteException {
        this.playbackControl("volume " + step);
    }

    public void playbackPause() throws ExecuteException {
        this.playbackControl("pause");
    }

    public void playbackTruncate() throws ExecuteException {
        this.playbackControl("truncate");
    }

    public void playbackRestart() throws ExecuteException {
        this.playbackControl("restart");
    }

    public void playbackSeek(int samples) throws ExecuteException {
        this.playbackControl("seek " + samples);
    }

    private void playbackControl(String cmd) throws ExecuteException {
        this.api.sendApiCommand("uuid_getvar", this._uuid + " " + cmd);
    }

    public void preAnswer() throws ExecuteException {
        this.sendExeMesg("pre_answer");
    }

    public void presence(String user, boolean in, String rpid, String message) throws ExecuteException {
        this.sendExeMesg("presence", in ? "in" : "out|" + user + "|" + rpid + "|" + message);
    }

    public void privacy(String type) throws ExecuteException {
        this.sendExeMesg("privacy", type);
    }

    public void queueDTMF(String digits) throws ExecuteException {
        this.queueDTMF(digits, 0);
    }

    public void queueDTMF(String digits, int durationsMillis) throws ExecuteException {
        this.sendExeMesg("dtmf_digits", digits + (durationsMillis > 0 ? "@" + durationsMillis : ""));
    }

    public String read(int min, int max, String soundFile, long timeout, String terminators) throws ExecuteException {
        String id = UUID.randomUUID().toString();
        CommandResponse resp = this.sendExeMesg("read", String.valueOf(min) + " " + max + " " + soundFile + " " + id + " " + timeout + " " + terminators);
        if (resp.isOk()) {
            EslMessage eslMessage = this.api.sendApiCommand("uuid_getvar", this._uuid + " " + id);
            if (eslMessage.getBodyLines().size() > 0) {
                return eslMessage.getBodyLines().get(0);
            }
        } else {
            throw new ExecuteException(resp.getReplyText());
        }
        return null;
    }

    public void record(String file) throws ExecuteException {
        this.record("record", null, 0, 0, 0, true, false, null, null, null, null, null, null, 0);
    }

    public void record(String file, boolean append, boolean wateResources, int timeLimitSeconds, int silenceThreshold, int silenceHits, String recordTile, String recordCopyright, String recordSoftware, String recordArtist, String recordComment, String recordDate, int recordRate) throws ExecuteException {
        this.record("record", file, timeLimitSeconds, silenceThreshold, silenceHits, wateResources, append, recordTile, recordCopyright, recordSoftware, recordArtist, recordComment, recordDate, recordRate);
    }

    public void recordSession(String file) throws ExecuteException {
        this.record("record_session", null, 0, 0, 0, true, false, null, null, null, null, null, null, 0);
    }

    public void recordSession(String file, boolean append, boolean wateResources, int timeLimitSeconds, int silenceThreshold, int silenceHits, String recordTile, String recordCopyright, String recordSoftware, String recordArtist, String recordComment, String recordDate, int recordRate) throws ExecuteException {
        this.record("record_session", file, timeLimitSeconds, silenceThreshold, silenceHits, wateResources, append, recordTile, recordCopyright, recordSoftware, recordArtist, recordComment, recordDate, recordRate);
    }

    private void record(String action, String file, int optionalTimeLimitSeconds, int optionalSilenceThreshold, int optionalSilenceHits, boolean wateResources, boolean append, String optionalRecordTile, String optionalRecordCopyright, String optionalRecordSoftware, String optionalRecordArtist, String optionalRecordComment, String optionalRecordDate, int optionalRecordRate) throws ExecuteException {
        if (this.nn(optionalRecordTile)) {
            this.set("RECORD_TITLE", optionalRecordTile);
        }
        if (this.nn(optionalRecordCopyright)) {
            this.set("RECORD_COPYRIGHT", optionalRecordCopyright);
        }
        if (this.nn(optionalRecordSoftware)) {
            this.set("RECORD_SOFTWARE", optionalRecordSoftware);
        }
        if (this.nn(optionalRecordArtist)) {
            this.set("RECORD_ARTIST", optionalRecordArtist);
        }
        if (this.nn(optionalRecordComment)) {
            this.set("RECORD_COMMENT", optionalRecordComment);
        }
        if (this.nn(optionalRecordDate)) {
            this.set("RECORD_DATE", optionalRecordDate);
        }
        if (optionalRecordRate > 0) {
            this.set("record_sample_rate", String.valueOf(optionalRecordRate));
        }
        this.set("RECORD_APPEND", String.valueOf(append));
        this.set("record_waste_resources", String.valueOf(wateResources));
        StringBuilder sb = new StringBuilder(file);
        if (optionalTimeLimitSeconds > 0) {
            sb.append(" ").append(optionalTimeLimitSeconds);
            if (optionalSilenceThreshold > 0) {
                sb.append(" ").append(optionalSilenceThreshold);
                if (optionalSilenceHits > 0) {
                    sb.append(" ").append(optionalSilenceHits);
                }
            }
        }
        this.sendExeMesg(action, sb.toString());
    }

    public void redirect(String endpoint) throws ExecuteException {
        this.sendExeMesg("redirect", endpoint);
    }

    public void respond(String code) throws ExecuteException {
        this.sendExeMesg("respond", code);
    }

    public void ringReady() throws ExecuteException {
        this.sendExeMesg("ring_ready");
    }

    public void say(String moduleName, String text, String sayType, String sayMethod) throws ExecuteException {
        this.say(moduleName, text, sayType, sayMethod, null);
    }

    public void say(String moduleName, String text, String sayType, String sayMethod, String gender) throws ExecuteException {
        StringBuilder sb = new StringBuilder(moduleName);
        sb.append(" ").append(sayType);
        sb.append(" ").append(sayMethod);
        if (this.nn(gender)) {
            sb.append(" ").append(gender);
        }
        sb.append(" ").append(text);
        this.sendExeMesg("say", sb.toString());
    }

    public void schedBroadcast(long seconds, boolean interval, String path, String leg) throws ExecuteException {
        StringBuilder sb = new StringBuilder();
        if (interval) {
            sb.append('+');
        }
        sb.append(seconds);
        sb.append(" ").append(path);
        sb.append(" ").append(leg);
        this.sendExeMesg("sched_broadcast", sb.toString());
    }

    public void schedHangup(long seconds, boolean interval) throws ExecuteException {
        this.schedHangup(seconds, interval, null);
    }

    public void schedHangup(long seconds, boolean interval, String cause) throws ExecuteException {
        StringBuilder sb = new StringBuilder();
        if (interval) {
            sb.append('+');
        }
        sb.append(seconds);
        if (this.nn(cause)) {
            sb.append(" ").append(cause);
        }
        this.sendExeMesg("sched_hangup", sb.toString());
    }

    public void schedTransfer(long seconds, boolean interval, String extension) throws ExecuteException {
        this.schedTransfer(seconds, interval, extension, null, null);
    }

    public void schedTransfer(long seconds, boolean interval, String extension, String dialPlan) throws ExecuteException {
        this.schedTransfer(seconds, interval, extension, dialPlan, null);
    }

    public void schedTransfer(long seconds, boolean interval, String extension, String dialPlan, String context) throws ExecuteException {
        StringBuilder sb = new StringBuilder();
        if (interval) {
            sb.append('+');
        }
        sb.append(seconds);
        sb.append(" ").append(extension);
        if (this.nn(dialPlan)) {
            sb.append(" ").append(dialPlan);
            if (this.nn(context)) {
                sb.append(" ").append(context);
            }
        }
        this.sendExeMesg("sched_transfer", sb.toString());
    }

    public void sendDTMF(String digits) throws ExecuteException {
        this.sendDTMF(digits, 0);
    }

    public void sendDTMF(String digits, int durationMillis) throws ExecuteException {
        StringBuilder sb = new StringBuilder(digits);
        if (durationMillis > 0) {
            sb.append('@').append(durationMillis);
        }
        this.sendExeMesg("send_dtmf", sb.toString());
    }

    public void set(String key, String value) throws ExecuteException {
        this.sendExeMesg("set", key + "=" + value);
    }

    public void speak(String engine, String voice, String message) throws ExecuteException {
        this.sendExeMesg("speak", engine + "|" + voice + "|" + message);
    }

    public void transfer(String destinationNumber) throws ExecuteException {
        this.transfer(destinationNumber, null, null);
    }

    public void transfer(String destinationNumber, String dialplan) throws ExecuteException {
        this.transfer(destinationNumber, dialplan, null);
    }

    public void transfer(String destinationNumber, String dialplan, String context) throws ExecuteException {
        StringBuilder sb = new StringBuilder(destinationNumber);
        if (this.nn(dialplan)) {
            sb.append(" ").append(dialplan);
            if (this.nn(context)) {
                sb.append(" ").append(context);
            }
        }
        this.sendExeMesg("transfer", sb.toString());
    }

    public String ApiCommand(String command, String args) {
        EslMessage eslMessage = this.api.sendApiCommand(command, args);
        StringBuilder sb = new StringBuilder();
        for (String line : eslMessage.getBodyLines()) {
            sb.append(line);
        }
        return sb.toString();
    }

    private CommandResponse sendExeMesg(String app) throws ExecuteException {
        return this.sendExeMesg(app, null);
    }

    private CommandResponse sendExeMesg(String app, String args) throws ExecuteException {
        CommandResponse resp;
        SendMsg msg = new SendMsg();
        msg.addCallCommand("execute");
        msg.addExecuteAppName(app);
        if (this.nn(args)) {
            msg.addExecuteAppArg(args);
        }
        if (!(resp = this.api.sendMessage(msg)).isOk()) {
            throw new ExecuteException(resp.getReplyText());
        }
        return resp;
    }

    private boolean nn(Object obj) {
        return obj != null;
    }
}

