/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.transport.message;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.TooLongFrameException;
import java.util.List;
import org.freeswitch.esl.client.transport.HeaderParser;
import org.freeswitch.esl.client.transport.message.EslHeaders;
import org.freeswitch.esl.client.transport.message.EslMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EslFrameDecoder
extends ReplayingDecoder<State> {
    static final byte LF = 10;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final int maxHeaderSize;
    private EslMessage currentMessage;
    private boolean treatUnknownHeadersAsBody = false;

    public EslFrameDecoder(int maxHeaderSize) {
        super((Object)State.READ_HEADER);
        if (maxHeaderSize <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be a positive integer: " + maxHeaderSize);
        }
        this.maxHeaderSize = maxHeaderSize;
    }

    public EslFrameDecoder(int maxHeaderSize, boolean treatUnknownHeadersAsBody) {
        this(maxHeaderSize);
        this.treatUnknownHeadersAsBody = treatUnknownHeadersAsBody;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        State state = (State)((Object)this.state());
        this.log.trace("decode() : state [{}]", (Object)state);
        switch (state) {
            case READ_HEADER: {
                if (this.currentMessage == null) {
                    this.currentMessage = new EslMessage();
                }
                boolean reachedDoubleLF = false;
                while (!reachedDoubleLF) {
                    String headerLine = this.readToLineFeedOrFail(buffer, this.maxHeaderSize);
                    this.log.debug("read header line [{}]", (Object)headerLine);
                    if (!headerLine.isEmpty()) {
                        String[] headerParts = HeaderParser.splitHeader(headerLine);
                        EslHeaders.Name headerName = EslHeaders.Name.fromLiteral(headerParts[0]);
                        if (headerName == null) {
                            if (this.treatUnknownHeadersAsBody) {
                                this.currentMessage.addBodyLine(headerLine);
                            } else {
                                throw new IllegalStateException("Unhandled ESL header [" + headerParts[0] + ']');
                            }
                        }
                        this.currentMessage.addHeader(headerName, headerParts[1]);
                    } else {
                        reachedDoubleLF = true;
                    }
                    this.checkpoint();
                }
                if (this.currentMessage.hasContentLength()) {
                    this.checkpoint((Object)State.READ_BODY);
                    this.log.debug("have content-length, decoding body ..");
                    break;
                }
                this.checkpoint((Object)State.READ_HEADER);
                EslMessage decodedMessage = this.currentMessage;
                this.currentMessage = null;
                out.add(decodedMessage);
                break;
            }
            case READ_BODY: {
                int contentLength = this.currentMessage.getContentLength();
                ByteBuf bodyBytes = buffer.readBytes(contentLength);
                this.log.debug("read [{}] body bytes", (Object)bodyBytes.writerIndex());
                while (bodyBytes.isReadable()) {
                    String bodyLine = this.readLine(bodyBytes, contentLength);
                    this.log.debug("read body line [{}]", (Object)bodyLine);
                    this.currentMessage.addBodyLine(bodyLine);
                }
                this.checkpoint((Object)State.READ_HEADER);
                EslMessage decodedMessage = this.currentMessage;
                this.currentMessage = null;
                out.add(decodedMessage);
                break;
            }
            default: {
                throw new Error("Illegal state: [" + (Object)((Object)state) + ']');
            }
        }
    }

    private String readToLineFeedOrFail(ByteBuf buffer, int maxLineLegth) throws TooLongFrameException {
        StringBuilder sb = new StringBuilder(64);
        byte nextByte;
        while ((nextByte = buffer.readByte()) != 10) {
            if (sb.length() >= maxLineLegth) {
                throw new TooLongFrameException("ESL header line is longer than " + maxLineLegth + " bytes.");
            }
            sb.append((char)nextByte);
        }
        return sb.toString();
    }

    private String readLine(ByteBuf buffer, int maxLineLength) throws TooLongFrameException {
        StringBuilder sb = new StringBuilder(64);
        while (buffer.isReadable()) {
            byte nextByte = buffer.readByte();
            if (nextByte == 10) {
                return sb.toString();
            }
            if (sb.length() >= maxLineLength) {
                throw new TooLongFrameException("ESL message line is longer than " + maxLineLength + " bytes.");
            }
            sb.append((char)nextByte);
        }
        return sb.toString();
    }

    protected static enum State {
        READ_HEADER,
        READ_BODY;

    }
}

