/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.outbound;

import com.google.common.util.concurrent.AbstractService;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.SocketAddress;
import org.freeswitch.esl.client.outbound.IClientHandlerFactory;
import org.freeswitch.esl.client.outbound.OutboundChannelInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClient
extends AbstractService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final IClientHandlerFactory clientHandlerFactory;
    private final SocketAddress bindAddress;
    private Channel serverChannel;

    public SocketClient(SocketAddress bindAddress, IClientHandlerFactory clientHandlerFactory) {
        this.bindAddress = bindAddress;
        this.clientHandlerFactory = clientHandlerFactory;
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
    }

    protected void doStart() {
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new OutboundChannelInitializer(this.clientHandlerFactory)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.serverChannel = bootstrap.bind(this.bindAddress).syncUninterruptibly().channel();
        this.notifyStarted();
        this.log.info("SocketClient waiting for connections on [{}] ...", (Object)this.bindAddress);
    }

    protected void doStop() {
        if (null != this.serverChannel) {
            this.serverChannel.close().awaitUninterruptibly();
        }
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
        this.notifyStopped();
        this.log.info("SocketClient stopped");
    }
}

