/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import org.freeswitch.esl.client.transport.event.EslEvent;
import org.freeswitch.esl.client.transport.message.EslHeaders;
import org.freeswitch.esl.client.transport.message.EslMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEslClientHandler
extends SimpleChannelInboundHandler<EslMessage> {
    public static final String MESSAGE_TERMINATOR = "\n\n";
    public static final String LINE_TERMINATOR = "\n";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ReentrantLock syncLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<CompletableFuture<EslMessage>> apiCalls = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<String, CompletableFuture<EslEvent>> backgroundJobs = new ConcurrentHashMap();
    private final ExecutorService backgroundJobExecutor = Executors.newCachedThreadPool();

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        for (CompletableFuture<EslMessage> completableFuture : this.apiCalls) {
            completableFuture.completeExceptionally(e.getCause());
        }
        for (CompletableFuture<Object> completableFuture : this.backgroundJobs.values()) {
            completableFuture.completeExceptionally(e.getCause());
        }
        ctx.close();
        ctx.fireExceptionCaught(e);
    }

    protected void channelRead0(ChannelHandlerContext ctx, EslMessage message) throws Exception {
        String contentType = message.getContentType();
        if (contentType.equals("text/event-plain") || contentType.equals("text/event-xml")) {
            EslEvent eslEvent = new EslEvent(message);
            if (eslEvent.getEventName().equals("BACKGROUND_JOB")) {
                String backgroundUuid = eslEvent.getEventHeaders().get("Job-UUID");
                CompletableFuture<EslEvent> future = this.backgroundJobs.remove(backgroundUuid);
                if (null != future) {
                    future.complete(eslEvent);
                }
            } else {
                this.handleEslEvent(ctx, eslEvent);
            }
        } else {
            this.handleEslMessage(ctx, message);
        }
    }

    protected void handleEslMessage(ChannelHandlerContext ctx, EslMessage message) {
        String contentType;
        this.log.info("Received message: [{}]", (Object)message);
        switch (contentType = message.getContentType()) {
            case "api/response": {
                this.log.debug("Api response received [{}]", (Object)message);
                this.apiCalls.poll().complete(message);
                break;
            }
            case "command/reply": {
                this.log.debug("Command reply received [{}]", (Object)message);
                this.apiCalls.poll().complete(message);
                break;
            }
            case "auth/request": {
                this.log.debug("Auth request received [{}]", (Object)message);
                this.handleAuthRequest(ctx);
                break;
            }
            case "text/disconnect-notice": {
                this.log.debug("Disconnect notice received [{}]", (Object)message);
                this.handleDisconnectionNotice();
                break;
            }
            default: {
                this.log.warn("Unexpected message content type [{}]", (Object)contentType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<EslMessage> sendApiSingleLineCommand(Channel channel, String command) {
        CompletableFuture<EslMessage> future = new CompletableFuture<EslMessage>();
        try {
            this.syncLock.lock();
            this.apiCalls.add(future);
            channel.writeAndFlush((Object)(command + MESSAGE_TERMINATOR));
        }
        finally {
            this.syncLock.unlock();
        }
        return future;
    }

    public CompletableFuture<EslMessage> sendSyncApiCommand(Channel channel, String command, String arg) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)command) ? 1 : 0) != 0, (Object)"command may not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)arg) ? 1 : 0) != 0, (Object)"arg may not be null or empty");
        return this.sendApiSingleLineCommand(channel, "api " + command + ' ' + arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<EslMessage> sendApiMultiLineCommand(Channel channel, List<String> commandLines) {
        StringBuilder sb = new StringBuilder();
        for (String line : commandLines) {
            sb.append(line);
            sb.append(LINE_TERMINATOR);
        }
        sb.append(LINE_TERMINATOR);
        CompletableFuture<EslMessage> future = new CompletableFuture<EslMessage>();
        try {
            this.syncLock.lock();
            this.apiCalls.add(future);
            channel.write((Object)sb.toString());
            channel.flush();
        }
        finally {
            this.syncLock.unlock();
        }
        return future;
    }

    public CompletableFuture<EslEvent> sendBackgroundApiCommand(Channel channel, String command) {
        return this.sendApiSingleLineCommand(channel, command).thenComposeAsync(result -> {
            if (result.hasHeader(EslHeaders.Name.JOB_UUID)) {
                String jobId = result.getHeaderValue(EslHeaders.Name.JOB_UUID);
                CompletableFuture resultFuture = new CompletableFuture();
                this.backgroundJobs.put(jobId, resultFuture);
                return resultFuture;
            }
            CompletableFuture resultFuture = new CompletableFuture();
            resultFuture.completeExceptionally(new IllegalStateException("Missing Job-UUID header in bgapi response"));
            return resultFuture;
        }, (Executor)this.backgroundJobExecutor);
    }

    protected abstract void handleEslEvent(ChannelHandlerContext var1, EslEvent var2);

    protected abstract void handleAuthRequest(ChannelHandlerContext var1);

    protected abstract void handleDisconnectionNotice();
}

