/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.inbound.reconnect;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import java.util.concurrent.TimeUnit;
import org.freeswitch.esl.client.inbound.Client;
import org.freeswitch.esl.client.internal.IModEslApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionListener
implements ChannelFutureListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Client client;

    public ConnectionListener(Client client) {
        this.client = client;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (!future.isSuccess()) {
            EventLoop loop = future.channel().eventLoop();
            loop.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectionListener.this.client.connect(ConnectionListener.this.client.getClientAddress(), ConnectionListener.this.client.getPassword(), ConnectionListener.this.client.getTimeoutSeconds());
                        Thread.sleep(1000L);
                        ConnectionListener.this.client.setEventSubscriptions(IModEslApi.EventFormat.PLAIN, ConnectionListener.this.client.getEvents());
                        ConnectionListener.this.logger.info("Reconnect {} freeswitch successful!", (Object)ConnectionListener.this.client.getClientAddress());
                    }
                    catch (Exception e) {
                        ConnectionListener.this.logger.debug("Reconnect {} failed!", (Object)ConnectionListener.this.client.getClientAddress());
                    }
                }
            }, 5L, TimeUnit.SECONDS);
        }
    }
}

