/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.inbound;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import java.util.concurrent.TimeUnit;
import org.freeswitch.esl.client.inbound.Client;
import org.freeswitch.esl.client.inbound.IEslProtocolListener;
import org.freeswitch.esl.client.internal.AbstractEslClientHandler;
import org.freeswitch.esl.client.internal.Context;
import org.freeswitch.esl.client.internal.IModEslApi;
import org.freeswitch.esl.client.transport.CommandResponse;
import org.freeswitch.esl.client.transport.event.EslEvent;
import org.freeswitch.esl.client.transport.message.EslMessage;

class InboundClientHandler
extends AbstractEslClientHandler {
    private final String password;
    private final IEslProtocolListener listener;
    private final Client client;

    public InboundClientHandler(String password, IEslProtocolListener listener, Client client) {
        this.password = password;
        this.listener = listener;
        this.client = client;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        EventLoop eventLoop = ctx.channel().eventLoop();
        eventLoop.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    InboundClientHandler.this.client.connect(InboundClientHandler.this.client.getClientAddress(), InboundClientHandler.this.client.getPassword(), InboundClientHandler.this.client.getTimeoutSeconds());
                    Thread.sleep(1000L);
                    InboundClientHandler.this.client.setEventSubscriptions(IModEslApi.EventFormat.PLAIN, InboundClientHandler.this.client.getEvents());
                    InboundClientHandler.this.log.info("Reconnect {} freeswitch successful!", (Object)InboundClientHandler.this.client.getClientAddress());
                }
                catch (Exception e) {
                    InboundClientHandler.this.log.debug("Reconnect {} failed!", (Object)InboundClientHandler.this.client.getClientAddress());
                }
            }
        }, 5L, TimeUnit.SECONDS);
        super.channelInactive(ctx);
    }

    @Override
    protected void handleEslEvent(ChannelHandlerContext ctx, EslEvent event) {
        this.log.debug("Received event: [{}]", (Object)event);
        this.listener.eventReceived(new Context(ctx.channel(), this), event);
    }

    @Override
    protected void handleAuthRequest(ChannelHandlerContext ctx) {
        this.log.debug("Auth requested, sending [auth {}]", (Object)"*****");
        this.sendApiSingleLineCommand(ctx.channel(), "auth " + this.password).thenAccept(response -> {
            this.log.debug("Auth response [{}]", response);
            if (!response.getContentType().equals("command/reply")) {
                this.log.error("Bad auth response message [{}]", response);
                throw new IllegalStateException("Incorrect auth response");
            }
            CommandResponse commandResponse = new CommandResponse("auth " + this.password, (EslMessage)response);
            this.listener.authResponseReceived(commandResponse);
        });
    }

    @Override
    protected void handleDisconnectionNotice() {
        this.log.debug("Received disconnection notice");
        this.listener.disconnected();
    }
}

