/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.security.sdk.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.uccc.security.model.App;
import com.uccc.security.model.Group;
import com.uccc.security.model.Permission;
import com.uccc.security.model.Role;
import com.uccc.security.model.Tenant;
import com.uccc.security.model.User;
import com.uccc.security.model.UserExtPermission;
import com.uccc.security.sdk.core.SecurityApiManager;
import com.uccc.security.sdk.exception.RequestException;
import com.uccc.security.sdk.http.HttpManager;
import com.uccc.security.sdk.model.AddExtPermissionResultJson;
import com.uccc.security.sdk.model.AppList;
import com.uccc.security.sdk.model.CreateAppResultJson;
import com.uccc.security.sdk.model.CreateGroupResultJson;
import com.uccc.security.sdk.model.CreatePermissionResultJson;
import com.uccc.security.sdk.model.CreateRoleResultJson;
import com.uccc.security.sdk.model.CreateTenantResultJson;
import com.uccc.security.sdk.model.CreateUserResultJson;
import com.uccc.security.sdk.model.GetGroupUserPageResultJson;
import com.uccc.security.sdk.model.GetPermissionExpressionResultJson;
import com.uccc.security.sdk.model.GetRolePermissionsResultJson;
import com.uccc.security.sdk.model.GetTenantGroupPageResultJson;
import com.uccc.security.sdk.model.GetTenantResultJson;
import com.uccc.security.sdk.model.GetTenantRolePageResultJson;
import com.uccc.security.sdk.model.GetTenantUserPageResultJson;
import com.uccc.security.sdk.model.GetUserPermissionsResultJson;
import com.uccc.security.sdk.model.GetUserResultJson;
import com.uccc.security.sdk.model.GetUserRolesResultJson;
import com.uccc.security.sdk.model.LoginResultJson;
import com.uccc.security.sdk.model.PageResultJson;
import com.uccc.security.sdk.model.UpdateAppResultJson;
import com.uccc.security.sdk.util.JsonUtil;
import com.uccc.security.util.ResultJson;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpSecurityApiManager
implements SecurityApiManager {
    private static final HttpManager httpClient = new HttpManager();
    private CloseableHttpClient client = httpClient.getClient();
    private String host;
    private String appKey;
    private boolean failedByException = true;

    private ResultJson simpleGet(String url) {
        try {
            HttpGet get = new HttpGet(url);
            get.setHeader("app", this.appKey);
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);
            return this.getResultJson((HttpResponse)response);
        }
        catch (Exception e) {
            throw new RequestException(e);
        }
    }

    private ResultJson simpleDelete(String uri) {
        try {
            HttpDelete delete = new HttpDelete(uri);
            delete.setHeader("app", this.appKey);
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)delete);
            return this.getResultJson((HttpResponse)response);
        }
        catch (Exception e) {
            throw new RequestException(e);
        }
    }

    private ResultJson simplePost(String url, Object params) {
        try {
            HttpPost post = new HttpPost(url);
            post.setHeader("app", this.appKey);
            post.setEntity((HttpEntity)new ByteArrayEntity(JSON.toJSONString((Object)params).getBytes(), ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)post);
            return this.getResultJson((HttpResponse)response);
        }
        catch (Exception e) {
            throw new RequestException(e);
        }
    }

    private ResultJson simplePut(String uri, Object params) {
        try {
            HttpPut post = new HttpPut(uri);
            post.setHeader("app", this.appKey);
            post.setEntity((HttpEntity)new ByteArrayEntity(JSON.toJSONString((Object)params).getBytes(), ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)post);
            return this.getResultJson((HttpResponse)response);
        }
        catch (Exception e) {
            throw new RequestException(e);
        }
    }

    private ResultJson getResultJson(HttpResponse response) throws IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 400) {
            throw new RequestException("get an error response status:" + status);
        }
        String content = IOUtils.toString((InputStream)response.getEntity().getContent());
        if (content != null && content.length() > 0) {
            ResultJson result = (ResultJson)JSON.toJavaObject((JSON)JSONObject.parseObject((String)content), ResultJson.class);
            if (!result.isSuccess()) {
                throw new RequestException("get an error response,code=" + result.getCode() + ",message=" + result.getMessage());
            }
            return result;
        }
        return new ResultJson(true, null);
    }

    @Override
    public LoginResultJson login(final String value, final String deviceId) {
        HashedMap params = new HashedMap(){
            {
                this.put("value", value);
                this.put("deviceId", deviceId);
            }
        };
        String uri = this.host + "/login";
        ResultJson rj = this.simplePost(uri, params);
        LoginResultJson loginResultJson = new LoginResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)loginResultJson);
        JSONObject data = (JSONObject)rj.getData();
        if (data != null) {
            loginResultJson.setTenantId(data.getLong("tenantId")).setToken(data.getString("token")).setUserId(data.getLong("userId")).setUserName(data.getString("userName"));
        }
        return loginResultJson;
    }

    @Override
    public CreateAppResultJson createApp(App app) {
        String uri = this.host + "/apps";
        ResultJson rj = this.simplePost(uri, app);
        CreateAppResultJson result = new CreateAppResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        if (data != null) {
            app = (App)data.toJavaObject(App.class);
            result.setApp(app);
        }
        return result;
    }

    @Override
    public ResultJson deleteAppByName(String name) {
        String uri = this.host + "/apps/deleteByName/" + name;
        return this.simpleDelete(uri);
    }

    @Override
    public ResultJson deleteApp(Long appId) {
        String uri = this.host + "/apps/" + appId;
        return this.simpleDelete(uri);
    }

    @Override
    public UpdateAppResultJson updateApp(Long appId, App app) {
        String uri = this.host + "/apps/" + appId;
        ResultJson rj = this.simplePut(uri, app);
        UpdateAppResultJson result = new UpdateAppResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        if (data != null) {
            app = (App)data.toJavaObject(App.class);
            result.setApp(app);
        }
        return result;
    }

    @Override
    public AppList getApps() {
        try {
            String uri = this.host + "/apps";
            ResultJson rs = this.simpleGet(uri);
            JSONArray ars = (JSONArray)rs.getData();
            if (ars != null && ars.size() > 0) {
                ArrayList<App> apps = new ArrayList<App>();
                for (int i = 0; i < ars.size(); ++i) {
                    JSONObject jo = ars.getJSONObject(i);
                    App app = (App)jo.toJavaObject(App.class);
                    apps.add(app);
                }
                return new AppList().setApps(apps);
            }
        }
        catch (Exception e) {
            throw new RequestException(e);
        }
        return null;
    }

    @Override
    public CreateUserResultJson createUser(long tenantId, User user) {
        String uri = this.host + "/tenants/" + tenantId + "/users";
        ResultJson rj = this.simplePost(uri, user);
        CreateUserResultJson result = new CreateUserResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        if (rj.getData() != null) {
            JSONObject data = (JSONObject)rj.getData();
            result.setUser((User)data.toJavaObject(User.class));
        }
        return result;
    }

    @Override
    public ResultJson deleteUser(Long userId) {
        String uri = this.host + "/users/" + userId;
        return this.simpleDelete(uri);
    }

    @Override
    public ResultJson updateUser(long tenantId, Long userId, User user) {
        String uri = this.host + "/tenants/" + tenantId + "/users/" + userId;
        ResultJson rj = this.simplePut(uri, user);
        return rj;
    }

    @Override
    public GetUserResultJson getUser(Long userId) {
        String uri = this.host + "/users/" + userId;
        ResultJson rj = this.simpleGet(uri);
        GetUserResultJson result = new GetUserResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        if (data != null) {
            User user = (User)data.toJavaObject(User.class);
            result.setUser(user);
        }
        return result;
    }

    @Override
    public CreateTenantResultJson createTenant(Tenant tenant) {
        String uri = this.host + "/tenants";
        ResultJson rj = this.simplePost(uri, tenant);
        CreateTenantResultJson result = new CreateTenantResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        if (data != null) {
            tenant = (Tenant)data.toJavaObject(Tenant.class);
            result.setTenant(tenant);
        }
        return result;
    }

    @Override
    public ResultJson deleteTenant(Long tenantId) {
        String uri = this.host + "/tenants/" + tenantId;
        return this.simpleDelete(uri);
    }

    @Override
    public ResultJson updateTenant(Long tenantId, Tenant tenant) {
        String uri = this.host + "/tenants/" + tenantId;
        return this.simplePut(uri, tenant);
    }

    @Override
    public GetTenantResultJson getTenant(Long tenantId) {
        String uri = this.host + "/tenants/" + tenantId;
        ResultJson rj = this.simpleGet(uri);
        GetTenantResultJson result = new GetTenantResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        if (data != null) {
            Tenant tenant = (Tenant)data.toJavaObject(Tenant.class);
            result.setTenant(tenant);
        }
        return result;
    }

    @Override
    public GetTenantUserPageResultJson findTenantUserPageList(Long tenantId, Integer page, Integer pageSize) {
        String uri = this.host + "/tenants/" + tenantId + "/users?page=" + page + "&pageSize=" + pageSize;
        ResultJson rj = this.simpleGet(uri);
        GetTenantUserPageResultJson result = new GetTenantUserPageResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        PageResultJson<Tenant> tenantsPage = PageResultJson.toPageResult(data, Tenant.class);
        result.setPageResult(tenantsPage);
        return result;
    }

    @Override
    public GetTenantGroupPageResultJson findTenantGroupPageList(Long tenantId, Integer page, Integer pageSize) {
        String uri = this.host + "/tenants/" + tenantId + "/groups?page=" + page + "&pageSize=" + pageSize;
        ResultJson rj = this.simpleGet(uri);
        GetTenantGroupPageResultJson result = new GetTenantGroupPageResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        PageResultJson<Group> tenantsPage = PageResultJson.toPageResult(data, Group.class);
        result.setPageResult(tenantsPage);
        return result;
    }

    @Override
    public GetTenantRolePageResultJson findTenantRolePageList(Long tenantId, Integer page, Integer pageSize) {
        String uri = this.host + "/tenants/" + tenantId + "/roles?page=" + page + "&pageSize=" + pageSize;
        ResultJson rj = this.simpleGet(uri);
        GetTenantRolePageResultJson result = new GetTenantRolePageResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        PageResultJson<Role> tenantsPage = PageResultJson.toPageResult(data, Role.class);
        result.setPageResult(tenantsPage);
        return result;
    }

    @Override
    public CreateRoleResultJson createRole(Role role) {
        String uri = this.host + "/roles";
        ResultJson rj = this.simplePost(uri, role);
        CreateRoleResultJson result = new CreateRoleResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        if (data != null) {
            role = (Role)data.toJavaObject(Role.class);
            result.setRole(role);
        }
        return result;
    }

    @Override
    public ResultJson deleteRole(Long roleId) {
        String uri = this.host + "/roles/" + roleId;
        return this.simpleDelete(uri);
    }

    @Override
    public ResultJson updateRole(Long roleId, Role role) {
        String uri = this.host + "/roles/" + roleId;
        return this.simplePut(uri, role);
    }

    @Override
    public CreatePermissionResultJson createPermission(Permission permission) {
        String uri = this.host + "/permissions";
        ResultJson rj = this.simplePost(uri, permission);
        CreatePermissionResultJson result = new CreatePermissionResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        if (data != null) {
            permission = (Permission)data.toJavaObject(Permission.class);
            result.setPermission(permission);
        }
        return result;
    }

    @Override
    public ResultJson deletePermission(Long permissionId) {
        String uri = this.host + "/permissions/" + permissionId;
        return this.simpleDelete(uri);
    }

    @Override
    public ResultJson updatePermission(Long permissionId, Permission permission) {
        String uri = this.host + "/permissions/" + permissionId;
        return this.simplePut(uri, permission);
    }

    @Override
    public GetRolePermissionsResultJson getRolePermissions(Long roleId) {
        String uri = this.host + "/roles/" + roleId + "/permissions";
        ResultJson rj = this.simpleGet(uri);
        GetRolePermissionsResultJson result = new GetRolePermissionsResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONArray data = (JSONArray)rj.getData();
        if (data != null) {
            List<Permission> permissions = JsonUtil.jsonArrayToList(data, Permission.class);
            result.setPermissions(permissions);
        }
        return result;
    }

    @Override
    public ResultJson addRoleToUser(Long roleId, Long userId) {
        String uri = this.host + "/users/" + userId + "/roles";
        HashedMap params = new HashedMap();
        params.put("roleId", roleId);
        return this.simplePost(uri, params);
    }

    @Override
    public AddExtPermissionResultJson addExtPermissionToUser(Long userId, UserExtPermission extPermission) {
        String uri = this.host + "/users/" + userId + "/extPermissions";
        ResultJson rj = this.simplePost(uri, extPermission);
        AddExtPermissionResultJson result = new AddExtPermissionResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        if (data != null) {
            extPermission = (UserExtPermission)data.toJavaObject(UserExtPermission.class);
            result.setExtPermission(extPermission);
        }
        return result;
    }

    @Override
    public ResultJson deleteRolePermissionMapping(Long roleId, Long permissionId) {
        String uri = this.host + "/roles/" + roleId + "/permissions/" + permissionId;
        return this.simpleDelete(uri);
    }

    @Override
    public ResultJson addPermissionToRole(Long roleId, Long permissionId) {
        String uri = this.host + "/roles/" + roleId + "/permissions/" + permissionId;
        return this.simplePost(uri, null);
    }

    @Override
    public ResultJson deleteRoleUserMapping(Long roleId, Long userId) {
        String uri = this.host + "/roles/" + roleId + "/users/" + userId;
        return this.simpleDelete(uri);
    }

    @Override
    public GetUserPermissionsResultJson getUserPermissions(Long userId) {
        String uri = this.host + "/users/" + userId + "/permissions";
        ResultJson rj = this.simpleGet(uri);
        GetUserPermissionsResultJson result = new GetUserPermissionsResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONArray data = (JSONArray)rj.getData();
        if (data != null) {
            List<Permission> permissions = JsonUtil.jsonArrayToList(data, Permission.class);
            result.setPermissions(permissions);
        }
        return result;
    }

    @Override
    public GetUserRolesResultJson getUserRoles(Long userId) {
        String uri = this.host + "/users/" + userId + "/roles";
        ResultJson rj = this.simpleGet(uri);
        GetUserRolesResultJson result = new GetUserRolesResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONArray data = (JSONArray)rj.getData();
        if (data != null) {
            List<Role> roles = JsonUtil.jsonArrayToList(data, Role.class);
            result.setRoles(roles);
        }
        return result;
    }

    @Override
    public GetGroupUserPageResultJson getGroupUsersPageList(Long groupId, Integer page, Integer pageSize) {
        String uri = this.host + "/groups/" + groupId + "/users?page=" + page + "&pageSize=" + pageSize;
        ResultJson rj = this.simpleGet(uri);
        GetGroupUserPageResultJson result = new GetGroupUserPageResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        PageResultJson<User> userPage = PageResultJson.toPageResult(data, User.class);
        result.setPageResult(userPage);
        return result;
    }

    @Override
    public CreateGroupResultJson createGroup(Group group) {
        String uri = this.host + "/groups";
        ResultJson rj = this.simplePost(uri, group);
        CreateGroupResultJson result = new CreateGroupResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONObject data = (JSONObject)rj.getData();
        if (data != null) {
            group = (Group)data.toJavaObject(Group.class);
            result.setGroup(group);
        }
        return result;
    }

    @Override
    public ResultJson deleteGroup(Long groupId) {
        String uri = this.host + "/groups/" + groupId;
        return this.simpleDelete(uri);
    }

    @Override
    public ResultJson updateGroup(Long groupId, Group group) {
        String uri = this.host + "/groups/" + groupId;
        return this.simplePut(uri, group);
    }

    @Override
    public ResultJson addUserToGroup(Long userId, Long groupId) {
        String uri = this.host + "/users/" + userId + "/groups/" + groupId;
        return this.simplePost(uri, null);
    }

    @Override
    public GetPermissionExpressionResultJson getUserActivePermissionExpressions(Long userId) {
        String uri = this.host + "/users/" + userId + "/permissionExpressions";
        ResultJson rj = this.simpleGet(uri);
        GetPermissionExpressionResultJson result = new GetPermissionExpressionResultJson();
        ResultJson.copyResult((ResultJson)rj, (ResultJson)result);
        JSONArray data = (JSONArray)rj.getData();
        if (data != null) {
            ArrayList<String> expressions = new ArrayList<String>();
            for (int i = 0; i < data.size(); ++i) {
                expressions.add(data.getString(i));
            }
            result.setExpressions(expressions);
        }
        return result;
    }

    @Override
    public ResultJson checkPermission(long userId, String uri) {
        String reqUri = this.host + "/permissions/check/" + userId;
        HashedMap params = new HashedMap();
        params.put("uri", uri);
        return this.simplePost(reqUri, params);
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    @Override
    public void setFailedByException(boolean failedByException) {
        this.failedByException = failedByException;
    }
}

