/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.security.sdk.core;

import com.uccc.security.sdk.core.ApiFilter;
import com.uccc.security.sdk.core.HttpSecurityApiManager;
import com.uccc.security.sdk.core.SecurityApiManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiManagerProxy
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(ApiManagerProxy.class);
    private List<ApiFilter> apiFilters = new ArrayList<ApiFilter>();
    private boolean hasFilter = false;
    private SecurityApiManager target;

    private ApiManagerProxy(SecurityApiManager target) {
        this.target = target;
    }

    public static SecurityApiManager createHttpManager() {
        HttpSecurityApiManager instance = new HttpSecurityApiManager();
        Class<?>[] interfaces = instance.getClass().getInterfaces();
        Object proxy = Proxy.newProxyInstance(instance.getClass().getClassLoader(), interfaces, (InvocationHandler)new ApiManagerProxy(instance));
        return (SecurityApiManager)proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("start to execute api method:{}", (Object)method.toString());
        }
        if (this.hasFilter) {
            for (ApiFilter filter : this.apiFilters) {
                filter.pre(method, args);
            }
        }
        Object result = method.invoke((Object)this.target, args);
        if (log.isDebugEnabled()) {
            log.debug("api execute complete,method:{}", (Object)method.toString());
        }
        if (this.hasFilter) {
            for (ApiFilter filter : this.apiFilters) {
                filter.after(result);
            }
        }
        return result;
    }

    public ApiManagerProxy addFilter(ApiFilter apiFilter) {
        this.apiFilters.add(apiFilter);
        return this;
    }

    public ApiManagerProxy setApiFilters(List<ApiFilter> apiFilters) {
        this.apiFilters = apiFilters;
        return this;
    }
}

