/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.security.spring.interceptor;

import com.auth0.jwt.JWTVerifier;
import com.uccc.security.model.JwtCodeBean;
import com.uccc.security.sdk.core.SecurityApiManager;
import com.uccc.security.spring.exception.AuthorizationException;
import com.uccc.security.util.ResultJson;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class CCSecurityInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CCSecurityInterceptor.class);
    private String jwtSecret;
    private SecurityApiManager securityApiManager;
    private String servletPath;

    public CCSecurityInterceptor(String jwtSecret, SecurityApiManager securityApiManager) {
        this.jwtSecret = jwtSecret;
        this.securityApiManager = securityApiManager;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        JwtCodeBean jwtCodeBean = this.unpackJwtCode(request, response);
        if (jwtCodeBean == null) {
            log.warn("Authorization header not found,uri={}", (Object)request.getRequestURI());
            throw new AuthorizationException("Authorization header not found,uri=" + request.getRequestURI());
        }
        String uri = request.getRequestURI();
        if (this.servletPath != null) {
            uri = uri.replace(this.servletPath, "");
        }
        String method = request.getMethod().toLowerCase();
        String express = uri + ":" + method;
        ResultJson result = this.securityApiManager.checkPermission(Long.valueOf(jwtCodeBean.getUid()).longValue(), express);
        if (!result.isSuccess()) {
            log.warn("request permission failed,uri={},error={}", (Object)request.getRequestURI(), (Object)result.toString());
            throw new AuthorizationException("request permission failed,uri=" + request.getRequestURI() + ",error=" + result.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug("request is auth success,uri={}", (Object)request.getRequestURI());
        }
        return true;
    }

    private JwtCodeBean unpackJwtCode(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JWTVerifier jwtVerifier = new JWTVerifier(this.jwtSecret);
        String authHeader = request.getHeader("Authorization");
        if (StringUtils.isEmpty((Object)authHeader)) {
            response.setStatus(401);
            return null;
        }
        Map jwtMap = jwtVerifier.verify(authHeader);
        JwtCodeBean jwtCode = new JwtCodeBean().setExp(MapUtils.getLongValue((Map)jwtMap, (Object)"exp")).setIat(MapUtils.getLongValue((Map)jwtMap, (Object)"iat")).setIssure(MapUtils.getString((Map)jwtMap, (Object)"iss")).setTenantIds(MapUtils.getString((Map)jwtMap, (Object)"tenantIds")).setUid(MapUtils.getString((Map)jwtMap, (Object)"uid")).setAppKey(MapUtils.getString((Map)jwtMap, (Object)"appKey")).setDeviceId(MapUtils.getString((Map)jwtMap, (Object)"deviceId"));
        request.setAttribute("jwtCode", (Object)jwtCode);
        return jwtCode;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }
}

