/*
 * Decompiled with CFR 0.152.
 */
package cti.utils;

import cti.CEnum;
import cti.Message;
import cti.utils.MessageIDLocator;
import cti.utils.TEnumObjectFactory;
import cti.utils.TEnumTransformer;
import flexjson.ClassLocator;
import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;
import flexjson.ObjectFactory;
import flexjson.transformer.Transformer;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtocolUtils {
    private static AtomicInteger sequenceNumber = new AtomicInteger(0);
    private static JSONSerializer serializer = new JSONSerializer().exclude(new String[]{"*.class"}).transform((Transformer)new TEnumTransformer(), new Class[]{CEnum.class});
    private static Logger logger = LoggerFactory.getLogger(ProtocolUtils.class);
    private static JSONDeserializer deserializer = new JSONDeserializer().use(CEnum.class, (ObjectFactory)new TEnumObjectFactory()).use(null, (ClassLocator)new MessageIDLocator());

    public static int nextReferenceId() {
        if (sequenceNumber.get() == Integer.MAX_VALUE) {
            sequenceNumber.lazySet(0);
        }
        return sequenceNumber.getAndIncrement();
    }

    public static String toJSON(Message message) {
        try {
            return serializer.deepSerialize((Object)message);
        }
        catch (Exception e) {
            logger.error("toJSON error:", (Throwable)e);
            return null;
        }
    }

    public static Message fromJSON(String json) {
        logger.info("source json: {}", (Object)json);
        Message message = null;
        try {
            message = (Message)deserializer.deserialize(json);
        }
        catch (Exception e) {
            logger.error("fromJSON error:{}", (Object)e.getMessage());
        }
        logger.debug("taget message: {}", (Object)message);
        return message;
    }
}

