/*
 * Decompiled with CFR 0.152.
 */
package cti.tserver;

import cti.EventListener;
import cti.EventMessage;
import cti.Request;
import cti.tserver.Protocol;
import cti.tserver.TException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TServerProtocol
implements Protocol {
    private static final Logger logger = LoggerFactory.getLogger(TServerProtocol.class);
    private ActiveMQConnectionFactory connectionFactory;
    private Connection connection;
    private Session session;
    private Set<EventListener> eventListeners;
    private MessageProducer producer;

    public TServerProtocol(String username, String password, String url) {
        this.connectionFactory = new ActiveMQConnectionFactory(username, password, url);
        this.eventListeners = new HashSet<EventListener>();
    }

    @Override
    public void open() throws TException {
        try {
            this.connection = this.connectionFactory.createConnection();
            this.session = this.connection.createSession(false, 1);
            this.connection.start();
            ActiveMQTopic eventDest = new ActiveMQTopic("TServerEvent");
            MessageConsumer consumer = this.session.createConsumer((Destination)eventDest);
            TEventConsumer tConsumerListener = new TEventConsumer();
            this.connection.setExceptionListener((ExceptionListener)tConsumerListener);
            consumer.setMessageListener((MessageListener)tConsumerListener);
            ActiveMQQueue requestDest = new ActiveMQQueue("TServerRequest");
            this.producer = this.session.createProducer((Destination)requestDest);
            this.producer.setDeliveryMode(1);
        }
        catch (JMSException e) {
            logger.error("Occur error:", (Throwable)e);
            throw new TException(e);
        }
    }

    @Override
    public void close() throws TException {
        try {
            if (this.producer != null) {
                this.producer.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.stop();
                this.connection.close();
            }
        }
        catch (Exception e) {
            logger.error("Occur error:", (Throwable)e);
            throw new TException(e);
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    @Override
    public void send(Request request) throws TException {
        try {
            ObjectMessage message = this.session.createObjectMessage((Serializable)request);
            this.producer.send((Message)message);
        }
        catch (JMSException e) {
            logger.error("Occur error:", (Throwable)e);
            throw new TException(e);
        }
    }

    private class TEventConsumer
    implements MessageListener,
    ExceptionListener {
        private TEventConsumer() {
        }

        public void onException(JMSException ex) {
            logger.error("onException:", (Throwable)ex);
        }

        public void onMessage(Message msg) {
            try {
                ObjectMessage objectMessage;
                if (msg instanceof ObjectMessage && (objectMessage = (ObjectMessage)msg).getObject() instanceof EventMessage) {
                    EventMessage event = (EventMessage)objectMessage.getObject();
                    for (EventListener eventListener : TServerProtocol.this.eventListeners) {
                        eventListener.onEvent(event);
                    }
                }
            }
            catch (JMSException e) {
                logger.error("onMessage:", (Throwable)e);
            }
        }
    }
}

