/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static Logger logger = LoggerFactory.getLogger(DateUtils.class);
    private static final SimpleDateFormat secondFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat intDayFormat = new SimpleDateFormat("yyyyMMdd");

    public static String getSecondDate() {
        return secondFormat.format(new Date());
    }

    public static String getSecondDate(Date date) {
        return secondFormat.format(date);
    }

    public static String getIntDayDate(Date date) {
        return intDayFormat.format(date);
    }

    public static Date getStartDate(String date) {
        try {
            if (date.contains(":")) {
                return dayFormat.parse(date);
            }
            return dayFormat.parse(date + " 00:00:00");
        }
        catch (ParseException e) {
            logger.error("startDate has a error format:" + e);
            return null;
        }
    }

    public static Date getEndDate(String date) {
        try {
            if (date.contains(":")) {
                return dayFormat.parse(date);
            }
            return dayFormat.parse(date + " 23:59:59");
        }
        catch (ParseException e) {
            logger.error("endDate has a error format:" + e);
            return null;
        }
    }

    public static Date getTodayStart() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date getTodayEnd() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 0);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static int getIntHourOfDay() {
        Calendar cal = Calendar.getInstance();
        return cal.get(11);
    }
}

