/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.utils;

import flexjson.JSONSerializer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataUtils {
    private static Logger logger = LoggerFactory.getLogger(DataUtils.class);
    private static JSONSerializer serializer = new JSONSerializer().exclude(new String[]{"*.class"});

    public static Map<String, String> getParameters(String url) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String param : url.split("&")) {
            if (param.startsWith("from=")) {
                try {
                    String from = "";
                    if (param.indexOf("<sip:") > 0) {
                        from = param.substring(5, param.indexOf("<sip:")).replaceAll("\"", "");
                    }
                    parameters.put("from", from);
                }
                catch (Exception ex) {
                    logger.error("get from has a error:{}", (Object)ex.getMessage());
                }
                continue;
            }
            if (param.startsWith("to=")) {
                try {
                    String to = "";
                    if (param.indexOf("<sip:") > 0) {
                        to = param.substring(param.indexOf("<sip:") + 5, param.indexOf("@"));
                    }
                    parameters.put("to", to);
                }
                catch (Exception ex) {
                    logger.error("get to has a error:{}", (Object)ex.getMessage());
                }
                continue;
            }
            String[] ps = param.split("=");
            if (ps.length != 2) continue;
            parameters.put(ps[0], ps[1]);
        }
        return parameters;
    }

    public static String listToJson(Object target) {
        try {
            return serializer.deepSerialize(target);
        }
        catch (Exception e) {
            logger.error("toJSON error:", (Throwable)e);
            return null;
        }
    }

    public static String getMobilephone(int callType, String from, String to) {
        String mobilephone = "";
        if (callType == 3) {
            mobilephone = to;
        }
        return mobilephone;
    }

    public static String getParameterName(String result) {
        String rs = "";
        int resultInt = 0;
        if (StringUtils.isNumeric((String)result)) {
            resultInt = Integer.parseInt(result);
            switch (resultInt) {
                case 11: {
                    rs = "\u5f85\u56de\u8bbf";
                    break;
                }
                case 12: {
                    rs = "\u8003\u8651\u8d2d\u4e70";
                    break;
                }
                case 14: {
                    rs = "\u5df2\u62d2\u7edd\u8bbf\u95ee";
                    break;
                }
                case 15: {
                    rs = "\u5df2\u62d2\u7edd\u9500\u552e";
                    break;
                }
                case 16: {
                    rs = "\u7981\u6b62\u547c\u53eb";
                    break;
                }
                case 18: {
                    rs = "\u5df2\u6210\u4ea4";
                }
            }
        }
        return rs;
    }
}

