/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.service;

import com.uccc.cti.record.handlercommand.BaseHandlerCommand;
import com.uccc.cti.record.utils.DataUtils;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.DynamicChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPMessageHandler
extends SimpleChannelUpstreamHandler {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<String, BaseHandlerCommand> publishMap;

    public void setPublishMap(Map<String, BaseHandlerCommand> publishMap) {
        this.publishMap = publishMap;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.handleHttpRequest(ctx, e);
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        HttpRequest request = (HttpRequest)e.getMessage();
        String uri = URLDecoder.decode(request.getUri(), "UTF-8");
        this.logger.info("recevice the uri:{}", (Object)uri);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        DynamicChannelBuffer buffer = new DynamicChannelBuffer(2048);
        response.setContent((ChannelBuffer)buffer);
        response.setHeader("Content-Type", (Object)"text/html; charset=UTF-8");
        response.setHeader("Content-Length", (Object)response.getContent().writerIndex());
        String result = "success";
        if (!uri.contains("?")) {
            result = "failure";
        } else {
            String command = uri.substring(0, uri.indexOf("?"));
            BaseHandlerCommand baseHandlerCommand = this.publishMap.get(command);
            if (baseHandlerCommand != null) {
                Map<String, String> parameters = DataUtils.getParameters(uri.substring(uri.indexOf("?") + 1));
                result = baseHandlerCommand.handleCommand(parameters);
            }
        }
        buffer.writeBytes(result.getBytes("UTF-8"));
        Channel ch = e.getChannel();
        ch.write((Object)response);
        ch.disconnect();
        ch.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel ch = e.getChannel();
        Throwable cause = e.getCause();
        if (cause instanceof TooLongFrameException) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        cause.printStackTrace();
        if (ch.isConnected()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }
}

