/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.jobs;

import com.uccc.cti.record.cache.CacheService;
import com.uccc.cti.record.models.Call;
import java.util.Collection;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class RecordDailyJob
extends QuartzJobBean {
    private static final Logger logger = LoggerFactory.getLogger(RecordDailyJob.class);
    @Autowired
    private CacheService cacheService;
    private final long maxIdleTime = 0x6DDD00L;

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            Collection<Call> calls = this.cacheService.getAllCalls();
            for (Call call : calls) {
                if (System.currentTimeMillis() - call.getCreationTime() <= 0x6DDD00L) continue;
                logger.error("Beyond max idle time,the call:{}", (Object)call);
                this.cacheService.removeCall(call.getCallId());
            }
            logger.info("RecordDailyJob cleared calls");
        }
        catch (Exception e) {
            logger.error("RecordDailyJob error : ", (Throwable)e);
        }
    }
}

