/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.jms;

import com.uccc.cti.record.factory.DaemonThreadFactory;
import cti.EventMessage;
import cti.record.requests.RecordRequest;
import eventservice.DeliveryStrategy;
import eventservice.EventSubscriber;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Service;

@Service
public class AsynDeliveryStrategy
implements DeliveryStrategy,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(AsynDeliveryStrategy.class);
    private final ExecutorService tserverExector = Executors.newSingleThreadExecutor(new DaemonThreadFactory("TServerEventService"));
    private final ExecutorService recordExector = Executors.newSingleThreadExecutor(new DaemonThreadFactory("RecordRequestService"));

    public <T> void publishTo(final Iterable<EventSubscriber<T>> subscribers, final T event) {
        if (event instanceof EventMessage) {
            this.tserverExector.submit(new Runnable(){

                @Override
                public void run() {
                    for (EventSubscriber sub : subscribers) {
                        try {
                            sub.onEvent(event);
                        }
                        catch (Exception e) {
                            logger.error("publishTo tserverExector  thread occur error:", (Throwable)e);
                            e.printStackTrace();
                        }
                    }
                }
            });
        } else if (event instanceof RecordRequest) {
            this.recordExector.submit(new Runnable(){

                @Override
                public void run() {
                    for (EventSubscriber sub : subscribers) {
                        try {
                            sub.onEvent(event);
                        }
                        catch (Exception e) {
                            logger.error("publishTo recordExector  thread occur error:", (Throwable)e);
                            e.printStackTrace();
                        }
                    }
                }
            });
        } else {
            logger.warn("publishTo ERROR CtiMessage:{}", event);
        }
    }

    public void destroy() throws Exception {
        this.tserverExector.shutdown();
        this.recordExector.shutdown();
    }
}

