/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.jms;

import com.uccc.cti.record.cache.CacheService;
import com.uccc.cti.record.factory.DaemonThreadFactory;
import com.uccc.cti.record.jms.RequestSender;
import cti.Event;
import cti.EventMessage;
import cti.Message;
import cti.record.requests.RecordRequest;
import cti.tserver.events.EventAttachedDataChanged;
import cti.tserver.events.EventEstablished;
import cti.utils.ProtocolUtils;
import eventservice.EventService;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ActiveMQFactory
implements InitializingBean,
DisposableBean,
RequestSender {
    private static Logger logger = LoggerFactory.getLogger(ActiveMQFactory.class);
    private Connection connection = null;
    private Session session = null;
    @Value(value="${jms.BrokerUrl}")
    private String jmsBrokerUrl;
    @Value(value="${jms.BrokerUserName}")
    private String jmsUserName;
    @Value(value="${jms.BrokerPassword}")
    private String jmsPassword;
    @Autowired
    private CacheService cacheService;
    @Autowired
    private EventService eventService;
    private final JmsConsumer ocsConsumerListener = new JmsConsumer();
    private MessageProducer recordEventProducer = null;
    private final ExecutorService eventExecutorExector = Executors.newSingleThreadExecutor(new DaemonThreadFactory("JMSEvent"));
    private final ExecutorService requestExecutorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory("JMSRequest"));

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setJmsBrokerUrl(String jmsBrokerUrl) {
        this.jmsBrokerUrl = jmsBrokerUrl;
    }

    public void setJmsUserName(String jmsUserName) {
        this.jmsUserName = jmsUserName;
    }

    public void setJmsPassword(String jmsPassword) {
        this.jmsPassword = jmsPassword;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.jmsUserName, this.jmsPassword, this.jmsBrokerUrl);
            connectionFactory.setUseAsyncSend(true);
            connectionFactory.setAlwaysSessionAsync(false);
            connectionFactory.setOptimizeAcknowledge(true);
            this.connection = connectionFactory.createConnection();
            this.session = this.connection.createSession(false, 1);
            this.connection.setExceptionListener((ExceptionListener)this.ocsConsumerListener);
            this.connection.start();
            Topic eventDest = this.session.createTopic("TServerEvent");
            MessageConsumer consumer = this.session.createConsumer((Destination)eventDest);
            consumer.setMessageListener((MessageListener)this.ocsConsumerListener);
            Queue recordDest = this.session.createQueue("RecordRequest");
            MessageConsumer recordConsumer = this.session.createConsumer((Destination)recordDest);
            recordConsumer.setMessageListener((MessageListener)this.ocsConsumerListener);
            ActiveMQTopic recordEventDest = new ActiveMQTopic("RecordEvent");
            this.recordEventProducer = this.session.createProducer((Destination)recordEventDest);
            this.recordEventProducer.setDeliveryMode(1);
        }
        catch (Exception e) {
            logger.error("open error", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        try {
            this.eventExecutorExector.shutdownNow();
            this.requestExecutorService.shutdownNow();
            if (this.recordEventProducer != null) {
                this.recordEventProducer.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.stop();
                this.connection.close();
            }
        }
        catch (Exception e) {
            logger.error("close error", (Throwable)e);
        }
    }

    private void addCall(EventMessage eventMessage) {
        this.cacheService.addCall(eventMessage);
    }

    private void addCallInEstablish(EventMessage eventMessage) {
        EventEstablished eventEstablished = (EventEstablished)eventMessage;
        this.cacheService.setCallInEstablished(eventEstablished.getCallID());
    }

    private void insertContactHistories(EventAttachedDataChanged attachedData) {
        this.cacheService.insertContactHistories(attachedData);
    }

    @Override
    public void send(EventMessage event) {
        try {
            if (this.session != null && this.recordEventProducer != null) {
                logger.info("jms send {}", (Object)event);
                ObjectMessage eventMessage = this.session.createObjectMessage((Serializable)event);
                this.recordEventProducer.send((javax.jms.Message)eventMessage);
                logger.info("jms send {}", (Object)eventMessage);
            } else {
                logger.error("Because session or producer is null,Couldn't send jms request!");
            }
        }
        catch (JMSException e) {
            logger.error("JMS error:", (Throwable)e);
            e.printStackTrace();
        }
    }

    private class JmsConsumer
    implements MessageListener,
    ExceptionListener {
        private JmsConsumer() {
        }

        public void onMessage(final javax.jms.Message msg) {
            ActiveMQFactory.this.eventExecutorExector.submit(new Runnable(){

                @Override
                public void run() {
                    Message ctiMessage = null;
                    try {
                        EventMessage eventMessage;
                        ObjectMessage messsage;
                        if (msg instanceof ObjectMessage) {
                            messsage = (ObjectMessage)msg;
                            ctiMessage = (Message)messsage.getObject();
                        }
                        if (msg instanceof TextMessage) {
                            messsage = (TextMessage)msg;
                            ctiMessage = ProtocolUtils.fromJSON((String)messsage.getText());
                        }
                        if (ctiMessage != null && ctiMessage instanceof Event && (eventMessage = (EventMessage)ctiMessage).getThisDN() != null && eventMessage instanceof EventAttachedDataChanged) {
                            logger.info("jms receive event:{}", (Object)eventMessage);
                            EventAttachedDataChanged attachedData = (EventAttachedDataChanged)eventMessage;
                            ActiveMQFactory.this.insertContactHistories(attachedData);
                        }
                    }
                    catch (Exception e) {
                        logger.error("onMessage error", (Throwable)e);
                    }
                }
            });
            ActiveMQFactory.this.requestExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    Message ctiMessage = null;
                    try {
                        ObjectMessage messsage;
                        if (msg instanceof ObjectMessage) {
                            messsage = (ObjectMessage)msg;
                            ctiMessage = (Message)messsage.getObject();
                        }
                        if (msg instanceof TextMessage) {
                            messsage = (TextMessage)msg;
                            ctiMessage = ProtocolUtils.fromJSON((String)messsage.getText());
                        }
                        if (ctiMessage != null && ctiMessage instanceof RecordRequest) {
                            logger.info("jms receive recordRequest:{}", (Object)ctiMessage);
                            ActiveMQFactory.this.eventService.publish("RECORD", (Object)ctiMessage);
                        }
                    }
                    catch (Exception e) {
                        logger.error("onMessage error", (Throwable)e);
                    }
                }
            });
        }

        public void onException(JMSException ex) {
            logger.error("onException:", (Throwable)ex);
        }
    }
}

