/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.handlercommand;

import com.uccc.cti.record.db.mapper.RecordMapper;
import com.uccc.cti.record.handlercommand.BaseHandlerCommand;
import com.uccc.cti.record.models.CDR;
import com.uccc.cti.record.utils.DateUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipUtil;

@Service
public class HandlerZipInCdrCommand
implements BaseHandlerCommand {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RecordMapper recordMapper;
    @Value(value="${jingle-cti-zipPath}")
    private String zipPath;
    @Value(value="${jingle-cti-recordNFSPath}")
    private String recordNFSPath;

    public void setZipPath(String zipPath) {
        this.zipPath = zipPath;
    }

    public void setRecordNFSPath(String recordNFSPath) {
        this.recordNFSPath = recordNFSPath;
    }

    public void setRecordMapper(RecordMapper recordMapper) {
        this.recordMapper = recordMapper;
    }

    @Override
    public String handleCommand(Map<String, String> parameters) {
        String jsoncallback = null;
        try {
            int zipCount;
            File zipFile;
            jsoncallback = parameters.get("jsoncallback");
            Long tenantId = null;
            if (StringUtils.isNumeric((String)parameters.get("tenantId"))) {
                tenantId = Long.parseLong(parameters.get("tenantId"));
            }
            String resultType = parameters.get("resultType");
            String startTime = parameters.get("startTime");
            String endTime = parameters.get("endTime");
            Date startDate = DateUtils.getStartDate(startTime);
            Date endDate = DateUtils.getEndDate(endTime);
            String agentDN = parameters.get("agentDN");
            String[] extens = null;
            if (parameters.get("extens") != null) {
                extens = parameters.get("extens").split(",");
            }
            String number = parameters.get("number");
            if (startDate == null || endDate == null || startDate.getTime() > endDate.getTime()) {
                startDate = DateUtils.getTodayStart();
                endDate = DateUtils.getTodayEnd();
            }
            Integer minTime = 0;
            Integer maxTime = 0;
            if (StringUtils.isNotBlank((String)parameters.get("minTime")) && StringUtils.isNumeric((String)parameters.get("minTime"))) {
                minTime = Integer.parseInt(parameters.get("minTime"));
            }
            if (StringUtils.isNotBlank((String)parameters.get("maxTime")) && StringUtils.isNumeric((String)parameters.get("maxTime"))) {
                maxTime = Integer.parseInt(parameters.get("maxTime"));
            }
            if (minTime == 0 && maxTime == 0) {
                minTime = null;
                maxTime = null;
            }
            ArrayList<CDR> cdrs = new ArrayList();
            if ("1".equals(resultType)) {
                cdrs = this.recordMapper.getCDRInfoForZips(tenantId, startDate, endDate, extens, number, minTime, maxTime);
            }
            Date zipDate = new Date();
            String zipName = tenantId.toString() + "_" + DateUtils.getSecondDate(zipDate) + "_records.zip";
            File file = new File(this.zipPath + "/" + tenantId);
            if (!file.isDirectory()) {
                file.mkdir();
            }
            if (!file.isDirectory()) {
                file.mkdirs();
            }
            if (!(zipFile = new File(this.zipPath + "/" + tenantId + "/" + zipName)).exists()) {
                zipFile.createNewFile();
            }
            if ((zipCount = this.zip(cdrs, tenantId, zipFile)) >= 0) {
                if (resultType == null) {
                    resultType = "";
                }
                this.recordMapper.insertZipLog(tenantId, zipDate, startTime, endTime, zipName, Integer.toString(zipCount), resultType, false, agentDN);
                this.logger.info("success insert ziplogs :tenantId({}),createTime({}),startTime({}),endTime({}),fileName({}),num({}),resultType({}),down({}),agentDN({})", new Object[]{tenantId, zipDate, startTime, endTime, zipName, Integer.toString(zipCount), resultType, false, ""});
            }
            if (jsoncallback != null) {
                return jsoncallback + "({'result':'\u6210\u529f\u6253\u5305" + zipCount + "\u6761\u8bb0\u5f55\uff01'})";
            }
            return "\u6210\u529f\u6253\u5305" + zipCount + "\u6761\u8bb0\u5f55\uff01";
        }
        catch (Exception e) {
            this.logger.error("zipRecords error :" + e);
            if (jsoncallback != null) {
                return jsoncallback + "({'result':'\u6253\u5305\u5931\u8d25\uff01'})";
            }
            return "\u6253\u5305\u5931\u8d25\uff01";
        }
    }

    private int zip(List<CDR> cdrs, Long tenantId, File zipFile) {
        int num = 0;
        ArrayList<FileSource> entries = new ArrayList<FileSource>();
        ArrayList<String> list = new ArrayList<String>();
        try {
            for (CDR cdr : cdrs) {
                String nfsName = this.recordNFSPath + "/" + tenantId + "/" + DateUtils.getIntDayDate(cdr.getCreateTime()) + "/" + cdr.getFileName();
                File file = new File(nfsName);
                if (!file.exists() || list.contains(cdr.getFileName())) continue;
                this.logger.info("file:{} exists", (Object)cdr.getFileName());
                list.add(cdr.getFileName());
                ++num;
                entries.add(new FileSource(file.getName(), file));
            }
            if (entries.size() > 0) {
                ZipEntrySource[] entriesz = new ZipEntrySource[entries.size()];
                ZipUtil.addEntries(null, (ZipEntrySource[])entries.toArray(entriesz), (File)zipFile);
            }
            return num;
        }
        catch (Exception e) {
            this.logger.error("error zip records :" + e);
            return -1;
        }
    }
}

