/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.handlercommand;

import com.uccc.cti.record.db.mapper.RecordMapper;
import com.uccc.cti.record.handlercommand.BaseHandlerCommand;
import com.uccc.cti.record.models.ZipLog;
import com.uccc.cti.record.models.ZipLogResult;
import com.uccc.cti.record.utils.DataUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HandlerZipHistoryCommand
implements BaseHandlerCommand {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RecordMapper recordMapper;

    public void setRecordMapper(RecordMapper recordMapper) {
        this.recordMapper = recordMapper;
    }

    @Override
    public String handleCommand(Map<String, String> parameters) {
        Long tenantId = null;
        if (!StringUtils.isNumeric((String)parameters.get("tenantId"))) {
            return DataUtils.listToJson(new ZipLogResult(0, 1, null));
        }
        tenantId = Long.parseLong(parameters.get("tenantId"));
        String resultType = parameters.get("resultType");
        int page = 1;
        int offSet = 18;
        if (StringUtils.isNumeric((String)parameters.get("page")) && (page = Integer.parseInt(parameters.get("page"))) < 1) {
            page = 1;
        }
        if (StringUtils.isNumeric((String)parameters.get("offSet")) && (offSet = Integer.parseInt(parameters.get("offSet"))) < 1) {
            offSet = 18;
        }
        List<ZipLog> zipLogs = null;
        int count = this.recordMapper.selectZipLogsCount(tenantId, resultType);
        if (count > 0) {
            zipLogs = this.recordMapper.selectZipLogs(tenantId, resultType, page, offSet);
        }
        ZipLogResult result = new ZipLogResult(count, page, zipLogs);
        String jsoncallback = parameters.get("jsoncallback");
        if (jsoncallback != null) {
            return jsoncallback + "(" + DataUtils.listToJson(result) + ")";
        }
        return DataUtils.listToJson(result);
    }
}

