/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.handlercommand;

import com.uccc.cti.record.cache.CacheService;
import com.uccc.cti.record.db.mapper.RecordMapper;
import com.uccc.cti.record.handlercommand.BaseHandlerCommand;
import com.uccc.cti.record.models.Call;
import com.uccc.cti.record.models.Record;
import com.uccc.cti.record.utils.DataUtils;
import com.uccc.cti.record.utils.DateUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HandlerOrkaudioCommand
implements BaseHandlerCommand,
DisposableBean {
    @Autowired
    private RecordMapper recordMapper;
    @Autowired
    private CacheService cacheService;
    @Value(value="${jingle-cti-recordNFSPath}")
    private String recordNFSPath;
    @Value(value="${jingle-cti-orkaudioPath}")
    private String orkaudioPath;
    private ExecutorService exec = Executors.newCachedThreadPool();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setRecordNFSPath(String recordNFSPath) {
        this.recordNFSPath = recordNFSPath;
    }

    public void setOrkaudioPath(String orkaudioPath) {
        this.orkaudioPath = orkaudioPath;
    }

    public void setRecordMapper(RecordMapper recordMapper) {
        this.recordMapper = recordMapper;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public String handleCommand(Map<String, String> parameters) {
        this.exec.execute(new OrkCommand(parameters));
        return "success";
    }

    public void destroy() throws Exception {
        this.exec.shutdown();
    }

    class OrkCommand
    implements Runnable {
        private Map<String, String> parameters;

        public OrkCommand(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String recId;
            if (this.parameters.get("filename") == null || !this.parameters.get("filename").startsWith("records") || !this.parameters.get("filename").endsWith(".wav")) {
                return;
            }
            Record record = new Record();
            long ctiCallType = 3L;
            String string = recId = this.parameters.get("recid") != null ? this.parameters.get("recid") : "";
            if (StringUtils.isNumeric((String)this.parameters.get("tenantId"))) {
                record.setTenantId(Long.parseLong(this.parameters.get("tenantId")));
            }
            record.setFileName(this.parameters.get("filename").substring(this.parameters.get("filename").lastIndexOf("/") + 1));
            if ("inbound".equals(this.parameters.get("cti-call-type"))) {
                ctiCallType = 2L;
            }
            record.setLocalParty(this.parameters.get("localip"));
            record.setRemoteParty(this.parameters.get("remoteip"));
            record.setService(this.parameters.get("hostname"));
            record.setCtiCallId(this.parameters.get("cti-call-id"));
            record.setCtiCallType(ctiCallType);
            record.setRecId(recId);
            boolean established = HandlerOrkaudioCommand.this.cacheService.getCallInEstablished(record.getCtiCallId());
            if (StringUtils.isNumeric((String)this.parameters.get("duration"))) {
                record.setDuration(Integer.parseInt(this.parameters.get("duration")));
            }
            if (StringUtils.isNumeric((String)this.parameters.get("timestamp"))) {
                record.setCreateTime(new Date(Long.parseLong(this.parameters.get("timestamp") + "000")));
            }
            if (!record.getFileName().startsWith("nonativecallid") && record.getFileName().contains("_")) {
                File removeFile = new File(HandlerOrkaudioCommand.this.orkaudioPath + "/" + record.getTenantId() + "/" + DateUtils.getIntDayDate(new Date()) + "/" + record.getFileName());
                if (removeFile.exists()) {
                    removeFile.delete();
                }
                return;
            }
            String mobile = DataUtils.getMobilephone((int)ctiCallType, this.parameters.get("from"), this.parameters.get("to"));
            if (record.getCtiCallId() != null && established && HandlerOrkaudioCommand.this.cacheService.getCall(record.getCtiCallId()) != null) {
                Call call = HandlerOrkaudioCommand.this.cacheService.getCall(record.getCtiCallId());
                record.setSrc(call.getSrc());
                record.setExten(call.getExten());
                record.setDst(call.getDst());
                record.setFileName(call.getFilename());
                if (call.getCallType() != null && call.getCallType() == 2) {
                    record.setCtiCallType(2L);
                } else {
                    record.setCtiCallType(3L);
                }
                HandlerOrkaudioCommand.this.cacheService.removeCall(record.getCtiCallId());
                HandlerOrkaudioCommand.this.cacheService.removeCallInEstablished(record.getCtiCallId());
            } else {
                record.setFileName(record.getCtiCallId() + "_" + mobile + ".wav");
                record.setSrc(DataUtils.getMobilephone((int)ctiCallType, this.parameters.get("from"), this.parameters.get("to")));
            }
            try {
                if (record.getFileName().startsWith("nonativecallid") || record.getTenantId() == null) {
                    Random random = new Random();
                    int s = random.nextInt(10000) % 10000 + 1;
                    String filename = this.parameters.get("from") + "-" + this.parameters.get("to") + "-" + new SimpleDateFormat("yyyyMMddHHmmss").format(record.getCreateTime()) + s + ".wav";
                    File srcFile = new File(HandlerOrkaudioCommand.this.orkaudioPath + "/notenantid/" + DateUtils.getIntDayDate(new Date()) + "/" + record.getFileName());
                    File destFile = new File(HandlerOrkaudioCommand.this.recordNFSPath + "/notenantid/" + DateUtils.getIntDayDate(new Date()) + "/" + filename);
                    FileUtils.moveFile((File)srcFile, (File)destFile);
                    record.setFileName(filename);
                } else {
                    File srcFile = new File(HandlerOrkaudioCommand.this.orkaudioPath + "/" + record.getTenantId() + "/" + DateUtils.getIntDayDate(new Date()) + "/" + record.getCtiCallId() + ".wav");
                    File destFile = new File(HandlerOrkaudioCommand.this.recordNFSPath + "/" + record.getTenantId() + "/" + DateUtils.getIntDayDate(new Date()) + "/" + record.getFileName());
                    FileUtils.moveFile((File)srcFile, (File)destFile);
                }
                HandlerOrkaudioCommand.this.logger.info("success to rename the file:{} success!", (Object)record.getFileName());
            }
            catch (IOException ex) {
                HandlerOrkaudioCommand.this.logger.error("failure to rename the file:{} has a error:{}", (Object)record.getFileName(), (Object)ex.getMessage());
                try {
                    if (ex.getMessage() != null && ex.getMessage().contains("already exists") && !record.getFileName().startsWith("nonativecallid")) {
                        File srcFile = new File(HandlerOrkaudioCommand.this.orkaudioPath + "/" + record.getTenantId() + "/" + DateUtils.getIntDayDate(new Date()) + "/" + record.getCtiCallId() + ".wav");
                        File destFile = new File(HandlerOrkaudioCommand.this.recordNFSPath + "/" + record.getTenantId() + "/" + DateUtils.getIntDayDate(new Date()) + "/" + record.getCtiCallId() + "_" + record.getFileName());
                        FileUtils.moveFile((File)srcFile, (File)destFile);
                        record.setFileName(record.getCtiCallId() + "_" + record.getFileName());
                    }
                }
                catch (IOException e) {
                    HandlerOrkaudioCommand.this.logger.error("failure to rename the file:{} has a error:{}", (Object)record.getFileName(), (Object)e.getMessage());
                }
            }
            finally {
                try {
                    HandlerOrkaudioCommand.this.recordMapper.inserRecord(record);
                    HandlerOrkaudioCommand.this.logger.info("insert record :{}", (Object)record.toString());
                }
                catch (Exception ex) {
                    HandlerOrkaudioCommand.this.logger.error("insert record has a error:{}", (Object)ex.getMessage());
                }
            }
        }
    }
}

