/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.handlercommand;

import com.uccc.cti.record.dispatcher.DispatchManager;
import com.uccc.cti.record.handlercommand.BaseHandlerRecordRequest;
import com.uccc.cti.record.models.CDR;
import cti.EventMessage;
import cti.record.Record;
import cti.record.events.EventApiRecordList;
import cti.record.requests.RequestApiRecordList;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HandlerApiRecordList
extends BaseHandlerRecordRequest<RequestApiRecordList> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected DispatchManager dispatchManager;

    public void setDispatchManager(DispatchManager dispatchManager) {
        this.dispatchManager = dispatchManager;
    }

    @Override
    public void onEvent(RequestApiRecordList request) {
        String thisDN = request.getThisDN();
        Integer limit = request.getLimit();
        Long tenantId = request.getTenantId();
        String otherDN = request.getOtherDN();
        List<CDR> cdrs = this.dispatchManager.findCDRsbyThisDN(tenantId, thisDN, otherDN, limit, null);
        EventApiRecordList eventApiRecordList = new EventApiRecordList();
        eventApiRecordList.setThisDN(request.getThisDN());
        eventApiRecordList.setCtxId(request.getCtxId());
        ArrayList<Record> records = new ArrayList<Record>();
        if (cdrs != null && cdrs.size() > 0) {
            for (CDR cdr : cdrs) {
                Record record = new Record();
                record.setCallId(cdr.getCtiCallId());
                record.setOtherDN(cdr.getOtherDN());
                record.setRecordDuration(cdr.getBillsec());
                record.setRecordURL(cdr.getFileName());
                record.setCreatedTimestamp(Long.valueOf(cdr.getCreateTime().getTime()));
                records.add(record);
            }
        }
        eventApiRecordList.setRecords(records);
        this.dispatchManager.send((EventMessage)eventApiRecordList);
    }
}

