/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.handlercommand;

import com.uccc.cti.record.dispatcher.DispatchManager;
import com.uccc.cti.record.handlercommand.BaseHandlerRecordRequest;
import com.uccc.cti.record.models.CDR;
import cti.EventMessage;
import cti.record.Record;
import cti.record.events.EventApiRecord;
import cti.record.requests.RequestApiRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HandlerAndroidApi
extends BaseHandlerRecordRequest<RequestApiRecord> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected DispatchManager dispatchManager;

    public void setDispatchManager(DispatchManager dispatchManager) {
        this.dispatchManager = dispatchManager;
    }

    @Override
    public void onEvent(RequestApiRecord request) {
        String callId = request.getCallId();
        Long tenantId = request.getTenantId();
        CDR cdr = this.dispatchManager.findCDRbyCallId(tenantId, callId);
        if (cdr != null) {
            EventApiRecord eventApiRecord = new EventApiRecord("");
            Record record = new Record();
            record.setCallId(cdr.getCtiCallId());
            record.setOtherDN(cdr.getOtherDN());
            record.setRecordDuration(cdr.getBillsec());
            record.setRecordURL(cdr.getFileName());
            record.setCreatedTimestamp(Long.valueOf(cdr.getCreateTime().getTime()));
            eventApiRecord.setRecord(record);
            eventApiRecord.setCtxId(request.getCtxId());
            this.dispatchManager.send((EventMessage)eventApiRecord);
        } else {
            EventApiRecord eventApiRecord = new EventApiRecord("");
            Record record = new Record();
            record.setCallId("");
            record.setOtherDN("");
            record.setRecordDuration(Integer.valueOf(0));
            record.setRecordURL("");
            record.setCreatedTimestamp(Long.valueOf(0L));
            eventApiRecord.setRecord(record);
            eventApiRecord.setCtxId(request.getCtxId());
            this.dispatchManager.send((EventMessage)eventApiRecord);
        }
    }
}

