/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.factory;

import com.uccc.cti.record.factory.DaemonThreadFactory;
import com.uccc.cti.record.factory.TEventExecutor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class TEventExecutoryFactory
implements TEventExecutor,
DisposableBean {
    private final ConcurrentMap<String, ExecutorService> tenantExecutors = new ConcurrentHashMap<String, ExecutorService>();

    @Override
    public void onEvent(String threadChannel, Runnable thread) {
        this.tenantExecutors.putIfAbsent(threadChannel, Executors.newSingleThreadExecutor(new DaemonThreadFactory(threadChannel)));
        ((ExecutorService)this.tenantExecutors.get(threadChannel)).submit(thread);
    }

    public void destroy() throws Exception {
        for (ExecutorService executor : this.tenantExecutors.values()) {
            executor.shutdown();
        }
    }
}

