/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.factory;

import cti.utils.GenericsUtil;
import eventservice.EventService;
import eventservice.EventSubscriber;
import eventservice.Predicate;
import eventservice.PredicateBuilder;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SubscriberFactoryBean
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SubscriberFactoryBean.class);
    private Set<EventSubscriber> eventSubscribers;
    private EventService eventService;
    private String channel;

    public void setEventSubscribers(Set<EventSubscriber> eventSubscribers) {
        this.eventSubscribers = eventSubscribers;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void afterPropertiesSet() throws Exception {
        for (EventSubscriber eventSubscriber : this.eventSubscribers) {
            Class managerEventClass = GenericsUtil.getSuperClassGenricType(eventSubscriber.getClass());
            Predicate eventFilter = PredicateBuilder.isInstanceOf((Class)managerEventClass);
            this.eventService.subscribe(this.channel, eventFilter, eventSubscriber);
            logger.info("Register subscriber [{}] to channel [{}]", (Object)eventSubscriber.getClass().getSimpleName(), (Object)this.channel);
        }
    }

    public void destroy() throws Exception {
        for (EventSubscriber eventSubscriber : this.eventSubscribers) {
            this.eventService.unsubscribe(eventSubscriber);
            logger.info("unRegister subscriber [{}] ", (Object)eventSubscriber.getClass().getSimpleName());
        }
    }
}

