/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.factory;

import com.uccc.cti.record.factory.DaemonThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ExecutorServiceFactory
implements InitializingBean,
DisposableBean,
FactoryBean<ExecutorService> {
    private final String namePrefix;
    private ExecutorService executorService;

    public ExecutorServiceFactory(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public ExecutorService getObject() throws Exception {
        return this.executorService;
    }

    public Class<?> getObjectType() {
        return ExecutorService.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void destroy() throws Exception {
        this.executorService.shutdown();
    }

    public void afterPropertiesSet() throws Exception {
        this.executorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory(this.namePrefix));
    }
}

