/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.dispatcher;

import com.uccc.cti.record.cache.CacheService;
import com.uccc.cti.record.db.mapper.RecordMapper;
import com.uccc.cti.record.dispatcher.DispatchManager;
import com.uccc.cti.record.jms.RequestSender;
import com.uccc.cti.record.models.Agent;
import com.uccc.cti.record.models.CDR;
import com.uccc.cti.record.models.CustomContactResult;
import com.uccc.cti.record.models.Record;
import com.uccc.cti.record.models.RecordResult;
import com.uccc.cti.record.utils.DataUtils;
import com.uccc.cti.record.utils.DateUtils;
import cti.EventMessage;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DispatchManagerImpl
implements DispatchManager,
InitializingBean,
DisposableBean {
    private static Logger logger = LoggerFactory.getLogger(DispatchManagerImpl.class);
    @Autowired
    private RecordMapper recordMapper;
    @Autowired
    private CacheService cacheService;
    @Autowired
    private RequestSender requestSender;

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setRecordMapper(RecordMapper recordMapper) {
        this.recordMapper = recordMapper;
    }

    public void setRequestSender(RequestSender requestSender) {
        this.requestSender = requestSender;
    }

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
    }

    @Override
    public RecordResult findAllByCondition(Long tenantId, Map<String, String> parameters) {
        String resultType;
        if (tenantId == null) {
            return new RecordResult(0, 1, null);
        }
        String number = StringUtils.isBlank((String)parameters.get("dst")) ? null : parameters.get("dst");
        Date startDate = DateUtils.getStartDate(parameters.get("startTime"));
        Date endDate = DateUtils.getEndDate(parameters.get("endTime"));
        if (startDate == null || endDate == null || startDate.getTime() > endDate.getTime()) {
            startDate = DateUtils.getTodayStart();
            endDate = DateUtils.getTodayEnd();
        }
        String[] extens = null;
        if (StringUtils.isNotBlank((String)parameters.get("extens"))) {
            extens = parameters.get("extens").split(",");
        }
        if (StringUtils.isNotBlank((String)(resultType = parameters.get("resultType"))) && resultType.equals("0")) {
            resultType = null;
        }
        int page = 1;
        int offSet = 18;
        Integer minTime = 0;
        Integer maxTime = 0;
        if (StringUtils.isNotBlank((String)parameters.get("minTime")) && StringUtils.isNumeric((String)parameters.get("minTime"))) {
            minTime = Integer.parseInt(parameters.get("minTime"));
        }
        if (StringUtils.isNotBlank((String)parameters.get("maxTime")) && StringUtils.isNumeric((String)parameters.get("maxTime"))) {
            maxTime = Integer.parseInt(parameters.get("maxTime"));
        }
        if (minTime == 0 && maxTime == 0) {
            minTime = null;
            maxTime = null;
        }
        if (StringUtils.isNotBlank((String)parameters.get("page")) && StringUtils.isNumeric((String)parameters.get("page")) && (page = Integer.parseInt(parameters.get("page"))) < 1) {
            page = 1;
        }
        if (StringUtils.isNotBlank((String)parameters.get("offSet")) && StringUtils.isNumeric((String)parameters.get("offSet")) && (offSet = Integer.parseInt(parameters.get("offSet"))) < 1) {
            offSet = 18;
        }
        List<Record> records = null;
        int count = this.recordMapper.selectRecordsCount(tenantId, startDate, endDate, number, resultType, extens, minTime, maxTime);
        logger.info("start find records count:" + count);
        if (count > 0) {
            records = this.recordMapper.selectRecords(tenantId, startDate, endDate, number, resultType, extens, page, offSet, minTime, maxTime);
            for (Record record : records) {
                Agent agent = this.cacheService.getAgentByTenantIdAndExten(record.getExten());
                if (agent == null) {
                    record.setAgentName("");
                } else {
                    record.setAgentName(agent.getName());
                }
                String value = DataUtils.getParameterName(record.getResult());
                if ("".equals(value)) {
                    CustomContactResult ccr;
                    value = record.getResult() != null && !"".equals(record.getResult()) ? ((ccr = this.recordMapper.selectCustomContactResult(tenantId, Integer.parseInt(record.getResult()))) == null ? "\u5176\u4ed6" : ccr.getValue()) : "\u5176\u4ed6";
                }
                record.setResult(value);
            }
        }
        RecordResult result = new RecordResult(count, page, records);
        return result;
    }

    @Override
    public void send(EventMessage event) {
        this.requestSender.send(event);
    }

    @Override
    public CDR findCDRbyCallId(Long tenantId, String callId) {
        if (tenantId != null && callId != null && !"".equals(callId)) {
            return this.recordMapper.selectCdrByCallId(tenantId, callId);
        }
        return null;
    }

    @Override
    public List<CDR> findCDRsbyThisDN(Long tenantId, String thisDN, String otherDN, Integer limit, Integer offset) {
        List<CDR> cdrs = this.recordMapper.selectCdrsByThisDN(tenantId, "491" + thisDN, otherDN, limit, offset);
        return cdrs;
    }

    @Override
    public List<CDR> findCDRsByCallIds(Long tenantId, String thisDN, String[] callIds) {
        List<CDR> cdrs = this.recordMapper.selectCdrsByCallIds(tenantId, callIds);
        return cdrs;
    }
}

