/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.cache;

import com.uccc.cti.record.cache.CacheService;
import com.uccc.cti.record.db.mapper.RecordMapper;
import com.uccc.cti.record.models.Agent;
import com.uccc.cti.record.models.Call;
import com.uccc.cti.record.models.ContactHistories;
import com.uccc.cti.record.utils.DateUtils;
import cti.CallType;
import cti.EventMessage;
import cti.tserver.events.EventAttachedDataChanged;
import cti.tserver.events.PartyEvent;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CacheServiceImpl
implements CacheService,
InitializingBean,
DisposableBean {
    private static Logger logger = LoggerFactory.getLogger(CacheServiceImpl.class);
    @Autowired
    private RecordMapper recordMapper;
    private final ScheduledExecutorService scheduledExecutor;
    private Map<String, Agent> agents = new HashMap<String, Agent>();
    private Map<String, String> customContactResults = new HashMap<String, String>();
    private Map<String, Boolean> establishings = new HashMap<String, Boolean>();
    @Value(value="${jingle-cti-cacheAgentsTime}")
    private int cacheAgentsTime;
    private final ConcurrentMap<String, Call> calls = new ConcurrentHashMap<String, Call>();

    public void setRecordMapper(RecordMapper recordMapper) {
        this.recordMapper = recordMapper;
    }

    public void setCacheAgentsTime(int cacheAgentsTime) {
        this.cacheAgentsTime = cacheAgentsTime;
    }

    public CacheServiceImpl() {
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
    }

    @Override
    public void addCall(EventMessage eventMessage) {
        PartyEvent partyEvent = (PartyEvent)eventMessage;
        Call call = (Call)this.calls.get(partyEvent.getCallID());
        CallType callType = partyEvent.getCallType();
        if (call == null) {
            int flag;
            call = new Call();
            call.setCallId(partyEvent.getCallID());
            if (callType != null) {
                call.setCallType(callType.intValue());
            }
            if (call.getTenantId() == null) {
                call.setTenantId(partyEvent.getTenantID());
            }
            if (call.getCreationTime() == null) {
                call.setCreationTime(partyEvent.getCreationTime());
            }
            int n = partyEvent.getCallType() == CallType.Outbound ? (partyEvent.getAttachDatas().containsKey("cti-campaign-id") && !"Preview".equals(partyEvent.getAttachDatas().get("campaignType")) ? 0 : 3) : (flag = 2);
            if (flag == 0) {
                call.setSrc(partyEvent.getOtherDN());
                call.setDst(partyEvent.getThisDN());
                call.setExten(partyEvent.getThisDN());
            } else if (flag == 2) {
                call.setSrc(partyEvent.getOtherDN());
                call.setDst(partyEvent.getThisDN());
                call.setExten(partyEvent.getThisDN());
            } else {
                call.setSrc(partyEvent.getOtherDN());
                call.setDst(partyEvent.getThisDN());
                call.setExten(partyEvent.getOtherDN());
            }
            Date eventTime = new Date(partyEvent.getCreationTime());
            String mobilephone = "";
            mobilephone = call.getSrc().contains("_") || call.getSrc().startsWith("8225") || call.getSrc().startsWith("05128225") ? call.getDst() : call.getSrc();
            String filename = DateUtils.getSecondDate(eventTime) + "_" + call.getExten() + "_" + mobilephone + ".wav";
            call.setFilename(filename);
            if (call.getSrc().contains("_") && call.getDst().contains("_")) {
                logger.error("receive the internal call");
            } else {
                this.calls.put(partyEvent.getCallID(), call);
            }
        } else if (partyEvent.getAttachDatas().containsKey("variable_thirdPartyRole") && "2".equals(partyEvent.getAttachDatas().get("variable_thirdPartyRole")) && !this.calls.containsKey(partyEvent.getCallID() + partyEvent.getThisDN())) {
            Call callConference = new Call();
            callConference.setCallId(partyEvent.getCallID() + partyEvent.getThisDN());
            callConference.setSrc(partyEvent.getThisDN());
            callConference.setDst(partyEvent.getOtherDN());
            callConference.setExten(partyEvent.getOtherDN());
            callConference.setCreationTime(partyEvent.getCreationTime());
            Date eventTime = new Date(partyEvent.getCreationTime());
            String mobilephone = "";
            mobilephone = callConference.getSrc().contains("_") || callConference.getSrc().startsWith("8225") || callConference.getSrc().startsWith("05128225") ? callConference.getDst() : callConference.getSrc();
            String filename = DateUtils.getSecondDate(eventTime) + "_" + callConference.getExten() + "_" + mobilephone + ".wav";
            callConference.setFilename(filename);
            if (callConference.getSrc().contains("_") && callConference.getDst().contains("_")) {
                logger.error("receive the internal call by conference");
            } else {
                this.calls.put(callConference.getCallId(), callConference);
            }
        } else if (partyEvent.getThirdDN() == null || "".equals(partyEvent.getThirdDN())) {
            int flag;
            int n = partyEvent.getCallType() == CallType.Outbound ? (partyEvent.getAttachDatas().containsKey("cti-campaign-id") && !"Preview".equals(partyEvent.getAttachDatas().get("campaignType")) ? 0 : 3) : (flag = 2);
            if (flag == 0) {
                call.setSrc(partyEvent.getOtherDN());
                call.setDst(partyEvent.getThisDN());
                call.setExten(partyEvent.getThisDN());
            } else if (flag == 2) {
                call.setSrc(partyEvent.getOtherDN());
                call.setDst(partyEvent.getThisDN());
                call.setExten(partyEvent.getThisDN());
            } else {
                call.setSrc(partyEvent.getOtherDN());
                call.setDst(partyEvent.getThisDN());
                call.setExten(partyEvent.getOtherDN());
            }
            Date eventTime = new Date(partyEvent.getCreationTime());
            String mobilephone = "";
            mobilephone = call.getSrc().contains("_") || call.getSrc().startsWith("8225") || call.getSrc().startsWith("05128225") ? call.getDst() : call.getSrc();
            String filename = DateUtils.getSecondDate(eventTime) + "_" + call.getExten() + "_" + mobilephone + ".wav";
            call.setFilename(filename);
            if (call.getSrc().contains("_") && call.getDst().contains("_")) {
                logger.error("receive the internal call");
            } else {
                this.calls.put(partyEvent.getCallID(), call);
            }
        }
    }

    @Override
    public Call getCall(String callId) {
        return (Call)this.calls.get(callId);
    }

    @Override
    public void removeCall(String callId) {
        if (callId != null && this.calls.containsKey(callId)) {
            this.calls.remove(callId);
        }
    }

    @Override
    public Collection<Call> getAllCalls() {
        return this.calls.values();
    }

    @Override
    public Agent getAgentByTenantIdAndExten(String exten) {
        Agent agent;
        block5: {
            agent = null;
            try {
                if (exten == null) {
                    return null;
                }
                agent = this.agents.get(exten);
                if (agent != null) break block5;
                String[] ps = exten.split("_");
                if (ps.length == 2 && StringUtils.isNumeric((String)ps[0])) {
                    agent = this.recordMapper.selectAgent(Long.parseLong(ps[0]), ps[1]);
                    if (agent == null) {
                        logger.error("can't find the agent tenantId_exten:{} in cache and database,", (Object)exten);
                        return null;
                    }
                    this.agents.put(agent.getTenantId() + "_" + agent.getExten(), agent);
                    break block5;
                }
                logger.error("can't find the agent from a error exten tenantId_exten:{},", (Object)exten);
                return null;
            }
            catch (Exception ex) {
                logger.error("getAgentByTenantIdAndExten has a error:{}", (Object)ex.getMessage());
            }
        }
        return agent;
    }

    public void afterPropertiesSet() throws Exception {
        List<Agent> users = this.recordMapper.selectAllAgent();
        for (Agent agent : users) {
            this.agents.put(agent.getTenantId() + "_" + agent.getExten(), agent);
        }
        this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    List<Agent> users = CacheServiceImpl.this.recordMapper.selectAllAgent();
                    for (Agent agent : users) {
                        CacheServiceImpl.this.agents.put(agent.getTenantId() + "_" + agent.getExten(), agent);
                    }
                }
                catch (Exception ex) {
                    logger.error("init select users table error in method afterPropertiesSet :{}", (Object)ex.getMessage());
                }
            }
        }, 0L, this.cacheAgentsTime, TimeUnit.MINUTES);
    }

    @Override
    public String getCustomContactResult(long tenantId, String result) {
        String value = "";
        if (result != null && !"".equals(result) && this.customContactResults.containsKey(String.valueOf(tenantId) + "_" + result)) {
            value = this.customContactResults.get(String.valueOf(tenantId) + "_" + result);
        }
        return value;
    }

    @Override
    public void setCustomContactResult(long tenantId, int num, String value) {
        this.customContactResults.put(String.valueOf(tenantId) + "_" + String.valueOf(num), value);
    }

    @Override
    public void insertContactHistories(EventAttachedDataChanged eventAttachedDataChanged) {
        ContactHistories contactHistories = new ContactHistories();
        contactHistories.setCallId(eventAttachedDataChanged.getCallID());
        contactHistories.setCallType(3);
        contactHistories.setChannelNumber((String)eventAttachedDataChanged.getAttachDatas().get("channel_number"));
        contactHistories.setContactResult(String.valueOf(3));
        contactHistories.setTenantId(eventAttachedDataChanged.getTenantID());
        if (eventAttachedDataChanged.getThisDN() != null && eventAttachedDataChanged.getThisDN().contains("_")) {
            Agent agent = this.getAgentByTenantIdAndExten(eventAttachedDataChanged.getThisDN());
            if (agent != null) {
                contactHistories.setUserName(agent.getXinming());
                contactHistories.setUserId(agent.getId());
            } else {
                contactHistories.setUserName("");
                contactHistories.setUserId(0L);
            }
        }
        this.recordMapper.inserContactHistories(contactHistories);
    }

    @Override
    public void setCallInEstablished(String callId) {
        this.establishings.put(callId, true);
    }

    @Override
    public void removeCallInEstablished(String callId) {
        if (this.establishings.containsKey(callId)) {
            this.establishings.remove(callId);
        }
    }

    @Override
    public boolean getCallInEstablished(String callId) {
        return callId != null && this.establishings.containsKey(callId);
    }

    public void destroy() throws Exception {
        this.agents.clear();
    }

    @Override
    public void setUserInfo(Long id, String thisDN) {
    }
}

