/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record.autoconfigure.eventservice;

import com.uccc.cti.record.factory.ExecutorServiceFactory;
import com.uccc.cti.record.factory.SubscriberFactoryBean;
import com.uccc.cti.record.handlercommand.BaseHandlerCommand;
import com.uccc.cti.record.handlercommand.HandlerAndroidApi;
import com.uccc.cti.record.handlercommand.HandlerApiRecordList;
import com.uccc.cti.record.handlercommand.HandlerApiRecordPageList;
import com.uccc.cti.record.handlercommand.HandlerOrkaudioCommand;
import com.uccc.cti.record.handlercommand.HandlerZipHistoryCommand;
import com.uccc.cti.record.handlercommand.HandlerZipInCdrCommand;
import com.uccc.cti.record.handlercommand.HandlerZipsCommand;
import com.uccc.cti.record.service.HTTPMessageHandler;
import eventservice.EventService;
import eventservice.EventSubscriber;
import java.util.HashMap;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SubscriberFactoryBeanAutoConfiguration {
    @Value(value="${jingle-cti-url-orktrack}")
    private String orktrack;
    @Value(value="${jingle-cti-url-zips}")
    private String zips;
    @Value(value="${jingle-cti-url-zipsincdr}")
    private String zipsincdr;
    @Value(value="${jingle-cti-url-ziphistory}")
    private String ziphistory;
    @Autowired
    private HandlerZipsCommand handlerZipsCommand;
    @Autowired
    private HandlerOrkaudioCommand HandlerOrkaudioCommand;
    @Autowired
    private HandlerZipInCdrCommand HandlerZipInCdrCommand;
    @Autowired
    private HandlerZipHistoryCommand HandlerZipHistoryCommand;
    @Autowired
    private EventService eventservice;
    @Autowired
    private HandlerAndroidApi handlerAndroidApi;
    @Autowired
    private HandlerApiRecordList handlerApiRecordList;
    @Autowired
    private HandlerApiRecordPageList handlerApiRecordPageList;

    @Bean
    public ExecutorServiceFactory recordExector() {
        return new ExecutorServiceFactory("recordExecutorService");
    }

    @Bean
    public ExecutorServiceFactory tserverExector() {
        return new ExecutorServiceFactory("recordExecutorService");
    }

    @Bean
    public SubscriberFactoryBean recordRequestSubscriber() {
        SubscriberFactoryBean subscriberFactoryBean = new SubscriberFactoryBean();
        subscriberFactoryBean.setEventService(this.eventservice);
        HashSet<EventSubscriber> eventSubscribers = new HashSet<EventSubscriber>();
        eventSubscribers.add(this.handlerAndroidApi);
        eventSubscribers.add(this.handlerAndroidApi);
        eventSubscribers.add(this.handlerApiRecordList);
        eventSubscribers.add(this.handlerApiRecordPageList);
        subscriberFactoryBean.setEventSubscribers(eventSubscribers);
        subscriberFactoryBean.setChannel("RECORD");
        return subscriberFactoryBean;
    }

    @Bean
    public HTTPMessageHandler OnHTTPHandler() {
        HTTPMessageHandler httpMessageHandler = new HTTPMessageHandler();
        HashMap<String, BaseHandlerCommand> publishMap = new HashMap<String, BaseHandlerCommand>();
        publishMap.put(this.orktrack, this.HandlerOrkaudioCommand);
        publishMap.put(this.zips, this.handlerZipsCommand);
        publishMap.put(this.zipsincdr, this.HandlerZipInCdrCommand);
        publishMap.put(this.ziphistory, this.HandlerZipHistoryCommand);
        httpMessageHandler.setPublishMap(publishMap);
        return httpMessageHandler;
    }
}

