/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.cti.record;

import com.uccc.cti.record.service.HTTPMessageHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HTTPFactoryBean
implements InitializingBean,
DisposableBean {
    private static Logger logger = LoggerFactory.getLogger(HTTPFactoryBean.class);
    @Value(value="${jingle-cti-port}")
    private int port;
    @Autowired
    private HTTPMessageHandler httpMessageHandler;
    private ServerBootstrap bootstrap;

    public void setHttpMessageHandler(HTTPMessageHandler httpMessageHandler) {
        this.httpMessageHandler = httpMessageHandler;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void destroy() throws Exception {
        this.bootstrap.releaseExternalResources();
    }

    public void afterPropertiesSet() throws Exception {
        try {
            logger.info("Netty Starting.");
            this.bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
            this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                public ChannelPipeline getPipeline() throws Exception {
                    ChannelPipeline pipeline = Channels.pipeline();
                    pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                    pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                    pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                    pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
                    pipeline.addLast("handler", (ChannelHandler)HTTPFactoryBean.this.httpMessageHandler);
                    return pipeline;
                }
            });
            this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
            logger.info("Netty Started." + this.port);
        }
        catch (Exception e) {
            logger.error("Netty Start Error:{}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

