/*
 * Decompiled with CFR 0.152.
 */
package eventservice.impl;

import eventservice.DeliveryStrategy;
import eventservice.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SyncDeliveryStrategy
implements DeliveryStrategy {
    private static final long serialVersionUID = 520679210752838981L;
    private static final Logger logger = LoggerFactory.getLogger(SyncDeliveryStrategy.class);

    @Override
    public <T> void publishTo(Iterable<EventSubscriber<T>> subscribers, T event) {
        for (EventSubscriber<T> sub : subscribers) {
            try {
                sub.onEvent(event);
            }
            catch (Exception e) {
                logger.error("EventService publish thread occur error :", (Throwable)e);
                e.printStackTrace();
            }
        }
    }
}

