/*
 * Decompiled with CFR 0.152.
 */
package eventservice.impl;

import eventservice.DeliveryStrategy;
import eventservice.EventService;
import eventservice.EventSubscriber;
import eventservice.Predicate;
import eventservice.impl.EventSubscriberSet;
import eventservice.impl.SubscriptionKey;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventServiceImpl
implements EventService {
    private static final long serialVersionUID = -6258706000610601268L;
    @Autowired
    private DeliveryStrategy deliveryStrategy;
    private final ConcurrentMap<SubscriptionKey, EssProvider> essProviders = new ConcurrentHashMap<SubscriptionKey, EssProvider>();
    private final String defaultChannel = "TSERVER";

    public EventServiceImpl(DeliveryStrategy deliveryStrategy) {
        this.deliveryStrategy = deliveryStrategy;
    }

    @Override
    public <T> void publish(String channel, T event) {
        ArrayList matchingSubscribers = new ArrayList();
        for (SubscriptionKey key : this.essProviders.keySet()) {
            if (!key.matches(channel, event)) continue;
            EventSubscriberSet ess = ((EssProvider)this.essProviders.get(key)).get();
            for (EventSubscriber<?> eventSub : ess.getEventSubscribers()) {
                matchingSubscribers.add(eventSub);
            }
        }
        this.deliveryStrategy.publishTo(matchingSubscribers, event);
    }

    @Override
    public <T> void publish(T event) {
        this.publish("TSERVER", event);
    }

    @Override
    public <T> EventSubscriber<T> subscribe(String channel, Predicate<T> eventFilter, EventSubscriber<T> subscriber) {
        SubscriptionKey key = new SubscriptionKey(channel, eventFilter);
        EssProvider newProvider = new EssProvider();
        EssProvider essProvider = this.essProviders.putIfAbsent(key, newProvider);
        if (essProvider == null) {
            essProvider = newProvider;
        }
        EventSubscriberSet subscribers = essProvider.get();
        subscribers.add(subscriber);
        return subscriber;
    }

    @Override
    public <T> EventSubscriber<T> subscribe(Predicate<T> eventFilter, EventSubscriber<T> subscriber) {
        return this.subscribe("TSERVER", eventFilter, subscriber);
    }

    @Override
    public <T> void unsubscribe(String channel, Predicate<T> eventFilter, EventSubscriber<T> subscriber) {
        SubscriptionKey key = new SubscriptionKey(channel, eventFilter);
        EssProvider essProvider = (EssProvider)this.essProviders.get(key);
        if (essProvider != null) {
            EventSubscriberSet subscribers = essProvider.get();
            subscribers.remove(subscriber);
        }
    }

    @Override
    public <T> void unsubscribe(EventSubscriber<T> subscriber) {
        for (EssProvider essProvider : this.essProviders.values()) {
            essProvider.get().remove(subscriber);
        }
    }

    private static class EssProvider {
        private EventSubscriberSet ess;

        private EssProvider() {
        }

        public synchronized EventSubscriberSet get() {
            if (this.ess == null) {
                this.ess = new EventSubscriberSet();
            }
            return this.ess;
        }
    }
}

