/*
 * Decompiled with CFR 0.152.
 */
package eventservice.impl;

import eventservice.DeliveryStrategy;
import eventservice.EventSubscriber;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynDeliveryStrategy
implements DeliveryStrategy {
    private static final long serialVersionUID = 8960268813381916878L;
    private static final Logger logger = LoggerFactory.getLogger(AsynDeliveryStrategy.class);
    private Executor taskExecutor;

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Override
    public <T> void publishTo(final Iterable<EventSubscriber<T>> subscribers, final T event) {
        Runnable publishTread = new Runnable(){

            @Override
            public void run() {
                for (EventSubscriber sub : subscribers) {
                    try {
                        sub.onEvent(event);
                    }
                    catch (Exception e) {
                        logger.error("EventService publish thread occur error:", (Throwable)e);
                        e.printStackTrace();
                    }
                }
            }
        };
        this.taskExecutor.execute(publishTread);
    }
}

