/*
 * Decompiled with CFR 0.152.
 */
package eventservice;

import eventservice.Predicate;

public abstract class PredicateBuilder {
    public static Predicate and(final Predicate ... predicates) {
        return new Predicate(){
            private static final long serialVersionUID = 2994590520608518397L;

            public boolean matches(Object root) {
                for (Predicate filter : predicates) {
                    if (filter.matches(root)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (Predicate filter : predicates) {
                    sb.append(" (" + filter + ") and");
                }
                return sb.toString();
            }
        };
    }

    public static Predicate isInstanceOf(final Class type) {
        return new Predicate(){
            private static final long serialVersionUID = 8206688930724798173L;

            public boolean matches(Object root) {
                return type.isInstance(root);
            }
        };
    }

    public static Predicate or(final Predicate ... predicates) {
        return new Predicate(){
            private static final long serialVersionUID = -6454866160286018575L;

            public boolean matches(Object root) {
                for (Predicate filter : predicates) {
                    if (!filter.matches(root)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (Predicate filter : predicates) {
                    sb.append(" (" + filter + ") or");
                }
                return sb.toString();
            }
        };
    }
}

