/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.dubbo;

import com.alibaba.dubbo.config.spring.AnnotationBean;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class DubboApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        ConfigurableEnvironment env = configurableApplicationContext.getEnvironment();
        String scan = env.getProperty("spring.dubbo.scan");
        if (scan != null) {
            AnnotationBean scanner = (AnnotationBean)BeanUtils.instantiate(AnnotationBean.class);
            scanner.setPackage(scan);
            scanner.setApplicationContext((ApplicationContext)configurableApplicationContext);
            configurableApplicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)scanner);
            configurableApplicationContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)scanner);
            configurableApplicationContext.getBeanFactory().registerSingleton("annotationBean", (Object)scanner);
        }
    }
}

