/*
 * Decompiled with CFR 0.152.
 */
package cti.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TenantUtil {
    private static final Logger logger = LoggerFactory.getLogger(TenantUtil.class);

    public static long ipToLong(String strIp) {
        if (strIp == null) {
            logger.error("Could not covert null ip");
            return 0L;
        }
        long[] ip = new long[4];
        int position1 = strIp.indexOf(".");
        int position2 = strIp.indexOf(".", position1 + 1);
        int position3 = strIp.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIp.substring(0, position1));
        ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIp.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static String getTenantID(String thisDN) {
        if (thisDN == null) {
            return null;
        }
        return thisDN.length() == 10 ? StringUtils.substring((String)thisDN, (int)0, (int)6) : null;
    }

    public static Long getTenantIDByDN(String thisDN) {
        String strTenantID;
        if (thisDN == null) {
            logger.warn("NULL DN could not got tenantID");
            return null;
        }
        String string = strTenantID = thisDN.length() == 10 ? StringUtils.substring((String)thisDN, (int)0, (int)6) : null;
        if (StringUtils.isNumeric((CharSequence)strTenantID)) {
            Long tenantID = TenantUtil.strToLong(strTenantID);
            if (tenantID >= 100000L) {
                return tenantID;
            }
            logger.error("tenantID:{} could not smaller than 100000", (Object)tenantID);
            return null;
        }
        logger.warn("DN {}  could not got tenantID", (Object)thisDN);
        return null;
    }

    public static String getAgentDN(String thisDN) {
        if (thisDN == null || !thisDN.contains("_")) {
            return null;
        }
        return thisDN;
    }

    public static boolean isOneTenant(String dn1, String dn2) {
        if (StringUtils.isBlank((CharSequence)dn1) || StringUtils.isBlank((CharSequence)dn2)) {
            return false;
        }
        if (dn1.length() < 6 || dn2.length() < 6) {
            return false;
        }
        return dn1.substring(0, 6).equals(dn2.substring(0, 6));
    }

    public static String getAgentIdByCCAgent(String agent) {
        if (agent == null) {
            return "";
        }
        if (agent.contains("_")) {
            return agent.substring(agent.indexOf("_") + 1);
        }
        if (agent.length() > 4) {
            return agent.substring(agent.length() - 4);
        }
        return agent;
    }

    public static long strToLong(String strValue) {
        long longValue = 0L;
        if (StringUtils.isNumeric((CharSequence)strValue)) {
            longValue = Integer.parseInt(strValue);
        } else {
            logger.warn("{} string could not convert to init", (Object)strValue);
        }
        return longValue;
    }

    public static Set<String> getLocalIps() {
        HashSet<String> localIps = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    logger.info("Got local ip address {}", (Object)inetAddress.getHostAddress());
                    localIps.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            logger.warn("getLocalIps error", (Throwable)e);
        }
        return localIps;
    }

    public static String getLocalNetIp(String ip) {
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            // empty if block
        }
        logger.info("Could not got Local Net IP by {}", (Object)ip);
        return null;
    }

    public static String getThisDNByContact(String contact) {
        String thisDN = "";
        if (contact != null && !"".equals(contact) && contact.contains("/")) {
            thisDN = contact.substring(contact.lastIndexOf("/") + 1);
        }
        return thisDN;
    }
}

