/*
 * Decompiled with CFR 0.152.
 */
package cti.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericsUtil {
    private static final Logger logger = LoggerFactory.getLogger(GenericsUtil.class);

    public static Class getSuperClassGenricType(Class clazz) {
        return GenericsUtil.getSuperClassGenricType(clazz, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class getGenericClass(Class clazz, int index) {
        Type[] genTypes;
        for (Type genType : genTypes = clazz.getGenericInterfaces()) {
            if (!(genType instanceof ParameterizedType)) continue;
            ParameterizedType pType = (ParameterizedType)genType;
            Type[] params = pType.getActualTypeArguments();
            if (!(params[index] instanceof Class)) {
                logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
                return Object.class;
            }
            return (Class)params[index];
        }
        return null;
    }

    public static Class getGenericClass(Class clazz) {
        return GenericsUtil.getGenericClass(clazz, 0);
    }
}

