/*
 * Decompiled with CFR 0.152.
 */
package cti.tserver.events;

import cti.EventMessage;
import cti.MessageID;
import cti.Queue;
import java.util.HashMap;
import java.util.Map;

public class EventTenantRealTimeData
extends EventMessage {
    private String agentDN;
    private Long tenantID;
    private int callsCount;
    private int inboundCount;
    private int outboundCount;
    private int queueCount;
    private int onlineCount;
    private int offlineCount;
    private int restCount;
    private int busyCount;
    private int afterCallWorkCount;
    private int satisfactionRate;
    private final Map<String, Queue> queues = new HashMap<String, Queue>();

    public EventTenantRealTimeData() {
    }

    public EventTenantRealTimeData(String thisDN) {
        this();
        this.setThisDN(thisDN);
        this.setAgentDN(thisDN);
    }

    @Override
    public Long getTenantID() {
        return this.tenantID;
    }

    @Override
    public int getMessageId() {
        return MessageID.EventTenantRealTimeData.intValue();
    }

    public String getAgentDN() {
        return this.agentDN;
    }

    public void setAgentDN(String agentDN) {
        this.agentDN = agentDN;
    }

    public void setTenantID(Long tenantID) {
        this.tenantID = tenantID;
    }

    public int getCallsCount() {
        return this.callsCount;
    }

    public void setCallsCount(int callsCount) {
        this.callsCount = callsCount;
    }

    public int getInboundCount() {
        return this.inboundCount;
    }

    public void setInboundCount(int inboundCount) {
        this.inboundCount = inboundCount;
    }

    public int getOutboundCount() {
        return this.outboundCount;
    }

    public void setOutboundCount(int outboundCount) {
        this.outboundCount = outboundCount;
    }

    public int getQueueCount() {
        int queueCount = 0;
        for (Queue queue : this.queues.values()) {
            queueCount += queue.getCount();
        }
        return queueCount;
    }

    public void setQueueCount(int queueCount) {
        this.queueCount = queueCount;
    }

    public int getOnlineCount() {
        return this.onlineCount;
    }

    public void setOnlineCount(int onlineCount) {
        this.onlineCount = onlineCount;
    }

    public int getOfflineCount() {
        return this.offlineCount;
    }

    public void setOfflineCount(int offlineCount) {
        this.offlineCount = offlineCount;
    }

    public int getRestCount() {
        return this.restCount;
    }

    public void setRestCount(int restCount) {
        this.restCount = restCount;
    }

    public int getBusyCount() {
        return this.busyCount;
    }

    public void setBusyCount(int busyCount) {
        this.busyCount = busyCount;
    }

    public int getAfterCallWorkCount() {
        return this.afterCallWorkCount;
    }

    public void setAfterCallWorkCount(int afterCallWorkCount) {
        this.afterCallWorkCount = afterCallWorkCount;
    }

    public int getSatisfactionRate() {
        return this.satisfactionRate;
    }

    public void setSatisfactionRate(int satisfactionRate) {
        this.satisfactionRate = satisfactionRate;
    }

    public Map<String, Queue> getQueues() {
        return this.queues;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventTenantRealTimeData that = (EventTenantRealTimeData)o;
        if (this.agentDN != null ? !this.agentDN.equals(that.agentDN) : that.agentDN != null) {
            return false;
        }
        return this.tenantID != null ? this.tenantID.equals(that.tenantID) : that.tenantID == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.agentDN != null ? this.agentDN.hashCode() : 0);
        result = 31 * result + (this.tenantID != null ? this.tenantID.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EventTenantRealTimeData{agentDN='" + this.agentDN + '\'' + ", tenantID=" + this.tenantID + ", callsCount=" + this.callsCount + ", inboundCount=" + this.inboundCount + ", outboundCount=" + this.outboundCount + ", queueCount=" + this.queueCount + ", onlineCount=" + this.onlineCount + ", offlineCount=" + this.offlineCount + ", restCount=" + this.restCount + ", busyCount=" + this.busyCount + ", afterCallWorkCount=" + this.afterCallWorkCount + ", satisfactionRate=" + this.satisfactionRate + ", queues=" + this.queues + "} " + super.toString();
    }
}

