/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.transport.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freeswitch.esl.client.transport.message.EslHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EslMessage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<EslHeaders.Name, String> headers = new HashMap<EslHeaders.Name, String>();
    private final List<String> body = new ArrayList<String>();
    private Integer contentLength = null;

    public Map<EslHeaders.Name, String> getHeaders() {
        return this.headers;
    }

    public boolean hasHeader(EslHeaders.Name headerName) {
        return this.headers.containsKey((Object)headerName);
    }

    public String getHeaderValue(EslHeaders.Name headerName) {
        return this.headers.get((Object)headerName);
    }

    public boolean hasContentLength() {
        return this.headers.containsKey((Object)EslHeaders.Name.CONTENT_LENGTH);
    }

    public Integer getContentLength() {
        if (this.contentLength != null) {
            return this.contentLength;
        }
        if (this.hasContentLength()) {
            this.contentLength = Integer.valueOf(this.headers.get((Object)EslHeaders.Name.CONTENT_LENGTH));
        }
        return this.contentLength;
    }

    public String getContentType() {
        return this.headers.get((Object)EslHeaders.Name.CONTENT_TYPE);
    }

    public List<String> getBodyLines() {
        return this.body;
    }

    void addHeader(EslHeaders.Name name, String value) {
        this.log.debug("adding header [{}] [{}]", (Object)name, (Object)value);
        this.headers.put(name, value);
    }

    void addBodyLine(String line) {
        if (line == null) {
            return;
        }
        this.body.add(line);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EslMessage: contentType=[");
        sb.append(this.getContentType());
        sb.append("] headers=");
        sb.append(this.headers.size());
        sb.append(", body=");
        sb.append(this.body.size());
        sb.append(" lines.");
        return sb.toString();
    }
}

