/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.transport.message;

import org.freeswitch.esl.client.internal.HeaderParser;
import org.freeswitch.esl.client.transport.message.EslHeaders;
import org.freeswitch.esl.client.transport.message.EslMessage;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EslFrameDecoder
extends ReplayingDecoder<State> {
    static final byte LF = 10;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final int maxHeaderSize;
    private EslMessage currentMessage;
    private boolean treatUnknownHeadersAsBody = false;

    public EslFrameDecoder(int maxHeaderSize) {
        super((Enum)State.READ_HEADER);
        if (maxHeaderSize <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be a positive integer: " + maxHeaderSize);
        }
        this.maxHeaderSize = maxHeaderSize;
    }

    public EslFrameDecoder(int maxHeaderSize, boolean treatUnknownHeadersAsBody) {
        this(maxHeaderSize);
        this.treatUnknownHeadersAsBody = treatUnknownHeadersAsBody;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        this.log.trace("decode() : state [{}]", (Object)state);
        switch (state) {
            case READ_HEADER: {
                if (this.currentMessage == null) {
                    this.currentMessage = new EslMessage();
                }
                boolean reachedDoubleLF = false;
                while (!reachedDoubleLF) {
                    String headerLine = this.readToLineFeedOrFail(buffer, this.maxHeaderSize);
                    this.log.debug("read header line [{}]", (Object)headerLine);
                    if (!headerLine.isEmpty()) {
                        String[] headerParts = HeaderParser.splitHeader(headerLine);
                        EslHeaders.Name headerName = EslHeaders.Name.fromLiteral(headerParts[0]);
                        if (headerName == null) {
                            if (this.treatUnknownHeadersAsBody) {
                                this.currentMessage.addBodyLine(headerLine);
                            } else {
                                throw new IllegalStateException("Unhandled ESL header [" + headerParts[0] + ']');
                            }
                        }
                        this.currentMessage.addHeader(headerName, headerParts[1]);
                    } else {
                        reachedDoubleLF = true;
                    }
                    this.checkpoint();
                }
                if (this.currentMessage.hasContentLength()) {
                    this.checkpoint(State.READ_BODY);
                    this.log.debug("have content-length, decoding body ..");
                    return null;
                }
                this.checkpoint(State.READ_HEADER);
                EslMessage decodedMessage = this.currentMessage;
                this.currentMessage = null;
                return decodedMessage;
            }
            case READ_BODY: {
                int contentLength = this.currentMessage.getContentLength();
                ChannelBuffer bodyBytes = buffer.readBytes(contentLength);
                this.log.debug("read [{}] body bytes", (Object)bodyBytes.writerIndex());
                while (bodyBytes.readable()) {
                    String bodyLine = this.readLine(bodyBytes, contentLength);
                    this.log.debug("read body line [{}]", (Object)bodyLine);
                    this.currentMessage.addBodyLine(bodyLine);
                }
                this.checkpoint(State.READ_HEADER);
                EslMessage decodedMessage = this.currentMessage;
                this.currentMessage = null;
                return decodedMessage;
            }
        }
        throw new Error("Illegal state: [" + (Object)((Object)state) + ']');
    }

    private String readToLineFeedOrFail(ChannelBuffer buffer, int maxLineLegth) throws TooLongFrameException {
        StringBuilder sb = new StringBuilder(64);
        byte nextByte;
        while ((nextByte = buffer.readByte()) != 10) {
            if (sb.length() >= maxLineLegth) {
                throw new TooLongFrameException("ESL header line is longer than " + maxLineLegth + " bytes.");
            }
            sb.append((char)nextByte);
        }
        return sb.toString();
    }

    private String readLine(ChannelBuffer buffer, int maxLineLength) throws TooLongFrameException {
        StringBuilder sb = new StringBuilder(64);
        while (buffer.readable()) {
            byte nextByte = buffer.readByte();
            if (nextByte == 10) {
                return sb.toString();
            }
            if (sb.length() >= maxLineLength) {
                throw new TooLongFrameException("ESL message line is longer than " + maxLineLength + " bytes.");
            }
            sb.append((char)nextByte);
        }
        return sb.toString();
    }

    protected static enum State {
        READ_HEADER,
        READ_BODY;

    }
}

