/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.transport;

import java.util.ArrayList;
import java.util.List;

public class SendMsg {
    private final List<String> msgLines = new ArrayList<String>();
    private final boolean hasUuid;

    public SendMsg() {
        this.msgLines.add("sendmsg");
        this.hasUuid = false;
    }

    public SendMsg(String uuid) {
        this.msgLines.add("sendmsg " + uuid);
        this.hasUuid = true;
    }

    public void addCallCommand(String command) {
        this.msgLines.add("call-command: " + command);
    }

    public void addExecuteAppName(String appName) {
        this.msgLines.add("execute-app-name: " + appName);
    }

    public void addExecuteAppArg(String arg) {
        this.msgLines.add("execute-app-arg: " + arg);
    }

    public void addLoops(int count) {
        this.msgLines.add("loops: " + count);
    }

    public void addHangupCause(String cause) {
        this.msgLines.add("hangup-cause: " + cause);
    }

    public void addNomediaUuid(String value) {
        this.msgLines.add("nomedia-uuid: " + value);
    }

    public void addEventLock() {
        this.msgLines.add("event-lock: true");
    }

    public void addGenericLine(String name, String value) {
        this.msgLines.add(name + ": " + value);
    }

    public List<String> getMsgLines() {
        return this.msgLines;
    }

    public boolean hasUuid() {
        return this.hasUuid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SendMsg: ");
        if (this.msgLines.size() > 1) {
            sb.append(this.msgLines.get(1));
        } else if (this.msgLines.size() > 0) {
            sb.append(0);
        }
        return sb.toString();
    }
}

