/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.transport;

import org.freeswitch.esl.client.transport.message.EslHeaders;
import org.freeswitch.esl.client.transport.message.EslMessage;

public class CommandResponse {
    private final String command;
    private final String replyText;
    private final EslMessage response;
    private final boolean success;

    public CommandResponse(String command, EslMessage response) {
        this.command = command;
        this.response = response;
        this.replyText = response.getHeaderValue(EslHeaders.Name.REPLY_TEXT);
        this.success = this.replyText.startsWith("+OK");
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isOk() {
        return this.success;
    }

    public String getReplyText() {
        return this.replyText;
    }

    public EslMessage getResponse() {
        return this.response;
    }
}

