/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.outbound.example;

import org.freeswitch.esl.client.outbound.AbstractOutboundClientHandler;
import org.freeswitch.esl.client.transport.SendMsg;
import org.freeswitch.esl.client.transport.event.EslEvent;
import org.freeswitch.esl.client.transport.message.EslHeaders;
import org.freeswitch.esl.client.transport.message.EslMessage;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;

public class SimpleHangupOutboundHandler
extends AbstractOutboundClientHandler {
    @Override
    protected void handleConnectResponse(ChannelHandlerContext ctx, EslEvent event) {
        this.log.info("Received connect response [{}]", (Object)event);
        if (!event.getEventName().equalsIgnoreCase("CHANNEL_DATA")) {
            throw new IllegalStateException("Unexpected event after connect: [" + event.getEventName() + ']');
        }
        this.log.info("=======================  incoming channel data  =============================");
        this.log.info("Event-Date-Local: [{}]", (Object)event.getEventDateLocal());
        this.log.info("Unique-ID: [{}]", (Object)event.getEventHeaders().get("Unique-ID"));
        this.log.info("Channel-ANI: [{}]", (Object)event.getEventHeaders().get("Channel-ANI"));
        this.log.info("Answer-State: [{}]", (Object)event.getEventHeaders().get("Answer-State"));
        this.log.info("Caller-Destination-Number: [{}]", (Object)event.getEventHeaders().get("Caller-Destination-Number"));
        this.log.info("=======================  = = = = = = = = = = =  =============================");
        this.hangupCall(ctx.getChannel());
    }

    @Override
    protected void handleEslEvent(ChannelHandlerContext ctx, EslEvent event) {
        this.log.info("Received event [{}]", (Object)event);
    }

    private void hangupCall(Channel channel) {
        SendMsg hangupMsg = new SendMsg();
        hangupMsg.addCallCommand("execute");
        hangupMsg.addExecuteAppName("hangup");
        EslMessage response = this.sendSyncMultiLineCommand(channel, hangupMsg.getMsgLines());
        if (response.getHeaderValue(EslHeaders.Name.REPLY_TEXT).startsWith("+OK")) {
            this.log.info("Call hangup successful");
        } else {
            this.log.error("Call hangup failed: [{}}", (Object)response.getHeaderValue(EslHeaders.Name.REPLY_TEXT));
        }
    }
}

