/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.outbound;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.freeswitch.esl.client.outbound.AbstractOutboundPipelineFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ChannelGroup allChannels = new DefaultChannelGroup("esl-socket-client");
    private final int port;
    private final ChannelFactory channelFactory;
    private final AbstractOutboundPipelineFactory pipelineFactory;

    public SocketClient(int port, AbstractOutboundPipelineFactory pipelineFactory) {
        this.port = port;
        this.pipelineFactory = pipelineFactory;
        this.channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
    }

    public void start() {
        ServerBootstrap bootstrap = new ServerBootstrap(this.channelFactory);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFactory);
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("child.keepAlive", (Object)true);
        Channel serverChannel = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        this.allChannels.add((Object)serverChannel);
        this.log.info("SocketClient waiting for connections on port [{}] ...", (Object)this.port);
    }

    public void stop() {
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        this.channelFactory.releaseExternalResources();
        this.log.info("SocketClient stopped");
    }
}

