/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.internal;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.freeswitch.esl.client.transport.event.EslEvent;
import org.freeswitch.esl.client.transport.message.EslHeaders;
import org.freeswitch.esl.client.transport.message.EslMessage;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEslClientHandler
extends SimpleChannelUpstreamHandler {
    public static final String MESSAGE_TERMINATOR = "\n\n";
    public static final String LINE_TERMINATOR = "\n";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Lock syncLock = new ReentrantLock();
    private final Queue<SyncCallback> syncCallbacks = new ConcurrentLinkedQueue<SyncCallback>();

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof EslMessage) {
            EslMessage message = (EslMessage)e.getMessage();
            String contentType = message.getContentType();
            if (contentType.equals("text/event-plain") || contentType.equals("text/event-xml")) {
                EslEvent eslEvent = new EslEvent(message);
                this.handleEslEvent(ctx, eslEvent);
            } else {
                this.handleEslMessage(ctx, (EslMessage)e.getMessage());
            }
        } else {
            throw new IllegalStateException("Unexpected message type: " + e.getMessage().getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EslMessage sendSyncSingleLineCommand(Channel channel, String command) {
        SyncCallback callback = new SyncCallback();
        this.syncLock.lock();
        try {
            this.syncCallbacks.add(callback);
            channel.write((Object)(command + MESSAGE_TERMINATOR));
        }
        finally {
            this.syncLock.unlock();
        }
        return callback.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EslMessage sendSyncMultiLineCommand(Channel channel, List<String> commandLines) {
        SyncCallback callback = new SyncCallback();
        StringBuilder sb = new StringBuilder();
        for (String line : commandLines) {
            sb.append(line);
            sb.append(LINE_TERMINATOR);
        }
        sb.append(LINE_TERMINATOR);
        this.syncLock.lock();
        try {
            this.syncCallbacks.add(callback);
            channel.write((Object)sb.toString());
        }
        finally {
            this.syncLock.unlock();
        }
        return callback.get();
    }

    public String sendAsyncCommand(Channel channel, String command) {
        EslMessage response = this.sendSyncSingleLineCommand(channel, command);
        if (response.hasHeader(EslHeaders.Name.JOB_UUID)) {
            return response.getHeaderValue(EslHeaders.Name.JOB_UUID);
        }
        throw new IllegalStateException("Missing Job-UUID header in bgapi response");
    }

    protected void handleEslMessage(ChannelHandlerContext ctx, EslMessage message) {
        this.log.info("Received message: [{}]", (Object)message);
        String contentType = message.getContentType();
        if (contentType.equals("api/response")) {
            this.log.debug("Api response received [{}]", (Object)message);
            this.syncCallbacks.poll().handle(message);
        } else if (contentType.equals("command/reply")) {
            this.log.debug("Command reply received [{}]", (Object)message);
            this.syncCallbacks.poll().handle(message);
        } else if (contentType.equals("auth/request")) {
            this.log.debug("Auth request received [{}]", (Object)message);
            this.handleAuthRequest(ctx);
        } else if (contentType.equals("text/disconnect-notice")) {
            this.log.debug("Disconnect notice received [{}]", (Object)message);
            this.handleDisconnectionNotice();
        } else {
            this.log.warn("Unexpected message content type [{}]", (Object)contentType);
        }
    }

    protected abstract void handleEslEvent(ChannelHandlerContext var1, EslEvent var2);

    protected abstract void handleAuthRequest(ChannelHandlerContext var1);

    protected abstract void handleDisconnectionNotice();

    private static class SyncCallback {
        private static final Logger log = LoggerFactory.getLogger(SyncCallback.class);
        private final CountDownLatch latch = new CountDownLatch(1);
        private EslMessage response;

        private SyncCallback() {
        }

        EslMessage get() {
            try {
                log.trace("awaiting latch ... ");
                this.latch.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            log.trace("returning response [{}]", (Object)this.response);
            return this.response;
        }

        void handle(EslMessage response) {
            this.response = response;
            log.trace("releasing latch for response [{}]", (Object)response);
            this.latch.countDown();
        }
    }
}

