/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.inbound;

import org.freeswitch.esl.client.inbound.SocketCloseListener;
import org.freeswitch.esl.client.internal.AbstractEslClientHandler;
import org.freeswitch.esl.client.internal.IEslProtocolListener;
import org.freeswitch.esl.client.transport.CommandResponse;
import org.freeswitch.esl.client.transport.event.EslEvent;
import org.freeswitch.esl.client.transport.message.EslMessage;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;

public class InboundClientHandler
extends AbstractEslClientHandler {
    private final String password;
    private final IEslProtocolListener listener;
    private SocketCloseListener closeListener;

    public InboundClientHandler(String password, IEslProtocolListener listener) {
        this.password = password;
        this.listener = listener;
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.log.warn("socket is closed:{}", (Object)ctx.getChannel());
        if (this.closeListener != null) {
            this.closeListener.closed();
        }
    }

    @Override
    protected void handleEslEvent(ChannelHandlerContext ctx, EslEvent event) {
        this.log.debug("Received event: [{}]", (Object)event);
        this.listener.eventReceived(event);
    }

    @Override
    protected void handleAuthRequest(ChannelHandlerContext ctx) {
        this.log.debug("Auth requested, sending [auth {}]", (Object)"*****");
        EslMessage response = this.sendSyncSingleLineCommand(ctx.getChannel(), "auth " + this.password);
        this.log.debug("Auth response [{}]", (Object)response);
        if (!response.getContentType().equals("command/reply")) {
            this.log.error("Bad auth response message [{}]", (Object)response);
            throw new IllegalStateException("Incorrect auth response");
        }
        CommandResponse commandResponse = new CommandResponse("auth " + this.password, response);
        this.listener.authResponseReceived(commandResponse);
    }

    @Override
    protected void handleDisconnectionNotice() {
        this.log.debug("Received disconnection notice");
        this.listener.disconnected();
    }

    public void setCloseListener(SocketCloseListener closeListener) {
        this.closeListener = closeListener;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        super.exceptionCaught(ctx, e);
    }
}

