/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.inbound;

import org.freeswitch.esl.client.inbound.SocketCloseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatChecker
implements Runnable {
    private static final int LOSE_TIME = 60;
    private final Logger log = LoggerFactory.getLogger(HeartbeatChecker.class);
    private long ltsActive = System.currentTimeMillis();
    private Boolean stop = false;
    private SocketCloseListener closeListener;

    public HeartbeatChecker(SocketCloseListener closeListener) {
        this.closeListener = closeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Boolean bl = this.stop;
        synchronized (bl) {
            long now;
            if (this.stop.booleanValue()) {
                throw new RuntimeException("\u9000\u51fa\u5fc3\u8df3\u68c0\u67e5");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("heartbeat check...");
            }
            if ((now = System.currentTimeMillis()) - this.ltsActive > 60000L) {
                this.log.warn("lose heartbeat event over {} seconds", (Object)60);
                this.closeListener.closed();
                return;
            }
            this.log.info("heartbeat is healthy");
        }
    }

    public synchronized void setLtsActive(long ltsActive) {
        this.ltsActive = ltsActive;
    }

    public synchronized void setStop(Boolean stop) {
        this.stop = stop;
    }
}

