/*
 * Decompiled with CFR 0.152.
 */
package org.freeswitch.esl.client.inbound;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.freeswitch.esl.client.IEslEventListener;
import org.freeswitch.esl.client.inbound.HeartbeatChecker;
import org.freeswitch.esl.client.inbound.InboundClientHandler;
import org.freeswitch.esl.client.inbound.InboundConnectionFailure;
import org.freeswitch.esl.client.inbound.InboundPipelineFactory;
import org.freeswitch.esl.client.inbound.ReconnectTask;
import org.freeswitch.esl.client.inbound.SocketCloseListener;
import org.freeswitch.esl.client.internal.IEslProtocolListener;
import org.freeswitch.esl.client.transport.CommandResponse;
import org.freeswitch.esl.client.transport.SendMsg;
import org.freeswitch.esl.client.transport.event.EslEvent;
import org.freeswitch.esl.client.transport.message.EslMessage;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
implements SocketCloseListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<IEslEventListener> eventListeners = new CopyOnWriteArrayList<IEslEventListener>();
    private final Executor eventListenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "EslEventNotifier-" + this.threadNumber.getAndIncrement());
        }
    });
    private final Executor backgroundJobListenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "EslBackgroundJobNotifier-" + this.threadNumber.getAndIncrement());
        }
    });
    private AtomicBoolean authenticatorResponded = new AtomicBoolean(false);
    private boolean authenticated;
    private CommandResponse authenticationResponse;
    private Channel channel;
    private HeartbeatChecker heartbeatChecker;
    private volatile Boolean reconnecting = false;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private String host;
    private int port;
    private String password;
    private int timeout;
    private String events = "HEARTBEAT";
    private final IEslProtocolListener protocolListener = new IEslProtocolListener(){

        @Override
        public void authResponseReceived(CommandResponse response) {
            Client.this.authenticatorResponded.set(true);
            Client.this.authenticated = response.isOk();
            Client.this.authenticationResponse = response;
            Client.this.log.debug("Auth response success={}, message=[{}]", (Object)Client.this.authenticated, (Object)response.getReplyText());
        }

        @Override
        public void eventReceived(final EslEvent event) {
            Client.this.log.debug("Event received [{}]", (Object)event);
            if ("HEARTBEAT".equals(event.getEventName())) {
                if (Client.this.log.isDebugEnabled()) {
                    Client.this.log.debug("received a heartbeat event");
                }
                if (Client.this.heartbeatChecker != null) {
                    Client.this.heartbeatChecker.setLtsActive(System.currentTimeMillis());
                }
            }
            if (event.getEventName().equals("BACKGROUND_JOB")) {
                for (final IEslEventListener listener : Client.this.eventListeners) {
                    Client.this.backgroundJobListenerExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                listener.backgroundJobResultReceived(event);
                            }
                            catch (Throwable t) {
                                Client.this.log.error("Error caught notifying listener of job result [" + event + ']', t);
                            }
                        }
                    });
                }
            } else {
                for (final IEslEventListener listener : Client.this.eventListeners) {
                    Client.this.eventListenerExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                listener.eventReceived(event);
                            }
                            catch (Throwable t) {
                                Client.this.log.error("Error caught notifying listener of event [" + event + ']', t);
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void disconnected() {
            Client.this.log.info("Disconnected ..");
        }
    };

    public boolean canSend() {
        return this.channel != null && this.channel.isConnected() && this.authenticated && this.reconnecting == false;
    }

    public void addEventListener(IEslEventListener listener) {
        if (listener != null) {
            this.eventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String host, int port, String password, int timeoutSeconds) throws InboundConnectionFailure {
        this.host = host;
        this.port = port;
        this.password = password;
        this.timeout = timeoutSeconds;
        if (this.heartbeatChecker != null) {
            this.heartbeatChecker.setStop(true);
        }
        if (this.canSend()) {
            this.close();
        }
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        InboundClientHandler handler = new InboundClientHandler(password, this.protocolListener);
        handler.setCloseListener(this);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new InboundPipelineFactory((ChannelHandler)handler));
        ChannelFuture future = bootstrap.connect((SocketAddress)new InetSocketAddress(host, port));
        if (!future.awaitUninterruptibly((long)timeoutSeconds, TimeUnit.SECONDS)) {
            throw new InboundConnectionFailure("Timeout connecting to " + host + ":" + port);
        }
        this.channel = future.getChannel();
        if (!future.isSuccess()) {
            this.log.warn("Failed to connect to [{}:{}]", (Object)host, (Object)port);
            this.log.warn("  * reason: {}", future.getCause());
            this.channel = null;
            bootstrap.releaseExternalResources();
            throw new InboundConnectionFailure("Could not connect to " + host + ":" + port, future.getCause());
        }
        while (!this.authenticatorResponded.get()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.authenticated) {
            throw new InboundConnectionFailure("Authentication failed: " + this.authenticationResponse.getReplyText());
        }
        this.heartbeatChecker = new HeartbeatChecker(this);
        this.scheduler.scheduleWithFixedDelay(this.heartbeatChecker, 0L, 2L, TimeUnit.SECONDS);
        Boolean bl = this.reconnecting;
        synchronized (bl) {
            this.reconnecting = false;
        }
    }

    public EslMessage sendSyncApiCommand(String command, String arg) {
        this.checkConnected();
        InboundClientHandler handler = (InboundClientHandler)this.channel.getPipeline().getLast();
        StringBuilder sb = new StringBuilder();
        if (command != null && !command.isEmpty()) {
            sb.append("api ");
            sb.append(command);
        }
        if (arg != null && !arg.isEmpty()) {
            sb.append(' ');
            sb.append(arg);
        }
        return handler.sendSyncSingleLineCommand(this.channel, sb.toString());
    }

    public String sendAsyncApiCommand(String command, String arg) {
        this.checkConnected();
        InboundClientHandler handler = (InboundClientHandler)this.channel.getPipeline().getLast();
        StringBuilder sb = new StringBuilder();
        if (command != null && !command.isEmpty()) {
            sb.append("bgapi ");
            sb.append(command);
        }
        if (arg != null && !arg.isEmpty()) {
            sb.append(' ');
            sb.append(arg);
        }
        return handler.sendAsyncCommand(this.channel, sb.toString());
    }

    public CommandResponse setEventSubscriptions(String format, String events) {
        this.setEvents(events);
        if (!format.equals("plain")) {
            throw new IllegalStateException("Only 'plain' event format is supported at present");
        }
        this.checkConnected();
        InboundClientHandler handler = (InboundClientHandler)this.channel.getPipeline().getLast();
        StringBuilder sb = new StringBuilder();
        if (format != null && !format.isEmpty()) {
            sb.append("event ");
            sb.append(format);
        }
        if (events != null && !events.isEmpty()) {
            sb.append(' ');
            sb.append(events);
        }
        EslMessage response = handler.sendSyncSingleLineCommand(this.channel, sb.toString());
        return new CommandResponse(sb.toString(), response);
    }

    public CommandResponse cancelEventSubscriptions() {
        this.checkConnected();
        InboundClientHandler handler = (InboundClientHandler)this.channel.getPipeline().getLast();
        EslMessage response = handler.sendSyncSingleLineCommand(this.channel, "noevents");
        return new CommandResponse("noevents", response);
    }

    public CommandResponse addEventFilter(String eventHeader, String valueToFilter) {
        this.checkConnected();
        InboundClientHandler handler = (InboundClientHandler)this.channel.getPipeline().getLast();
        StringBuilder sb = new StringBuilder();
        if (eventHeader != null && !eventHeader.isEmpty()) {
            sb.append("filter ");
            sb.append(eventHeader);
        }
        if (valueToFilter != null && !valueToFilter.isEmpty()) {
            sb.append(' ');
            sb.append(valueToFilter);
        }
        EslMessage response = handler.sendSyncSingleLineCommand(this.channel, sb.toString());
        return new CommandResponse(sb.toString(), response);
    }

    public CommandResponse deleteEventFilter(String eventHeader, String valueToFilter) {
        this.checkConnected();
        InboundClientHandler handler = (InboundClientHandler)this.channel.getPipeline().getLast();
        StringBuilder sb = new StringBuilder();
        if (eventHeader != null && !eventHeader.isEmpty()) {
            sb.append("filter delete ");
            sb.append(eventHeader);
        }
        if (valueToFilter != null && !valueToFilter.isEmpty()) {
            sb.append(' ');
            sb.append(valueToFilter);
        }
        EslMessage response = handler.sendSyncSingleLineCommand(this.channel, sb.toString());
        return new CommandResponse(sb.toString(), response);
    }

    public CommandResponse sendMessage(SendMsg sendMsg) {
        this.checkConnected();
        InboundClientHandler handler = (InboundClientHandler)this.channel.getPipeline().getLast();
        EslMessage response = handler.sendSyncMultiLineCommand(this.channel, sendMsg.getMsgLines());
        return new CommandResponse(sendMsg.toString(), response);
    }

    public CommandResponse setLoggingLevel(String level) {
        this.checkConnected();
        InboundClientHandler handler = (InboundClientHandler)this.channel.getPipeline().getLast();
        StringBuilder sb = new StringBuilder();
        if (level != null && !level.isEmpty()) {
            sb.append("log ");
            sb.append(level);
        }
        EslMessage response = handler.sendSyncSingleLineCommand(this.channel, sb.toString());
        return new CommandResponse(sb.toString(), response);
    }

    public CommandResponse cancelLogging() {
        this.checkConnected();
        InboundClientHandler handler = (InboundClientHandler)this.channel.getPipeline().getLast();
        EslMessage response = handler.sendSyncSingleLineCommand(this.channel, "nolog");
        return new CommandResponse("nolog", response);
    }

    public CommandResponse close() {
        this.checkConnected();
        InboundClientHandler handler = (InboundClientHandler)this.channel.getPipeline().getLast();
        EslMessage response = handler.sendSyncSingleLineCommand(this.channel, "exit");
        return new CommandResponse("exit", response);
    }

    private void checkConnected() {
        if (!this.canSend()) {
            throw new IllegalStateException("Not connected to FreeSWITCH Event Socket");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed() {
        Boolean bl = this.reconnecting;
        synchronized (bl) {
            if (this.reconnecting.booleanValue()) {
                this.log.warn("reconnecting task is already start");
                return;
            }
            this.reconnecting = true;
            ReconnectTask task = new ReconnectTask(this);
            this.scheduler.scheduleWithFixedDelay(task, 0L, 5L, TimeUnit.SECONDS);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPassword() {
        return this.password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getEvents() {
        return this.events;
    }

    public void setEvents(String events) {
        if ("all".equalsIgnoreCase(events)) {
            this.events = "all";
            return;
        }
        this.events = events.contains("HEARTBEAT") ? events : "HEARTBEAT " + events;
    }
}

