/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.commons.logging;

import com.uccc.commons.logging.LoggerWrapper;
import com.uccc.commons.logging.TeePrintWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ResponseWrapper
extends HttpServletResponseWrapper
implements LoggerWrapper {
    private long ignoreBodySize = 2048L;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private PrintWriter writer = new PrintWriter(this.out);

    public ResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ResponseWrapper(HttpServletResponse response, long ignoreBodySize) {
        super(response);
        this.ignoreBodySize = ignoreBodySize;
    }

    public PrintWriter getWriter() throws IOException {
        return new TeePrintWriter(super.getWriter(), this.writer);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){
            private OutputStream sourceOut;
            {
                this.sourceOut = ResponseWrapper.super.getOutputStream();
            }

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }

            public void write(int b) throws IOException {
                this.sourceOut.write(b);
                ResponseWrapper.this.out.write(b);
            }
        };
    }

    @Override
    public long getIgnoreBodySize() {
        return this.ignoreBodySize;
    }

    @Override
    public ByteArrayOutputStream getOut() {
        return this.out;
    }

    public void setIgnoreBodySize(long ignoreBodySize) {
        this.ignoreBodySize = ignoreBodySize;
    }
}

