/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.commons.logging;

import com.uccc.commons.logging.RequestWrapper;
import com.uccc.commons.logging.ResponseWrapper;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonLoggingFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(CommonLoggingFilter.class);
    private long ignoreBodySize = 2048L;
    private boolean merge = false;
    private boolean totalTime = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        String totalTimeString;
        String mergeString;
        String ignoreBodySizeStr = filterConfig.getInitParameter("ignoreBodySize");
        if (ignoreBodySizeStr != null && !ignoreBodySizeStr.trim().isEmpty()) {
            this.ignoreBodySize = Long.valueOf(ignoreBodySizeStr);
        }
        if ((mergeString = filterConfig.getInitParameter("mergeRequestAndResponse")) != null && !mergeString.trim().isEmpty()) {
            this.merge = Boolean.valueOf(mergeString);
        }
        if ((totalTimeString = filterConfig.getInitParameter("totalTime")) != null && !totalTimeString.trim().isEmpty()) {
            this.totalTime = Boolean.valueOf(totalTimeString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        long last = System.currentTimeMillis();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String method = request.getMethod();
        String query = request.getQueryString();
        String path = request.getRequestURI() + (query != null ? "?" + query : "");
        boolean info = this.log.isInfoEnabled();
        if (info) {
            servletRequest = new RequestWrapper(request, this.ignoreBodySize);
            servletResponse = new ResponseWrapper(response, this.ignoreBodySize);
        }
        if (!this.merge) {
            this.logRequest((RequestWrapper)servletRequest, method, path);
        }
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            if (info) {
                try {
                    if (!this.merge) {
                        this.logResponse((ResponseWrapper)servletResponse, method, path);
                    } else {
                        this.logMergedRequestAndResponse((RequestWrapper)servletRequest, (ResponseWrapper)servletResponse, method, path);
                    }
                    if (this.totalTime) {
                        this.logTotalTime((RequestWrapper)servletRequest, method, path, last);
                    }
                }
                catch (Exception e) {
                    this.log.error("Print log error", (Throwable)e);
                }
            }
        }
    }

    private void logRequest(RequestWrapper request, String method, String path) {
        StringBuilder requestMsg = new StringBuilder();
        String bodyString = this.getRequestBodyString(request);
        requestMsg.append("Request ").append(method).append(" ").append(path).append(" for ").append(bodyString);
        this.log.info(requestMsg.toString());
    }

    private String getRequestBodyString(RequestWrapper request) {
        if (this.isBinaryContent((HttpServletRequest)request) || this.isMultipart((HttpServletRequest)request) || request.isBiggerThanIgnoreBody()) {
            return "{}";
        }
        byte[] bodyArray = request.toByteArray();
        if (bodyArray == null || bodyArray.length == 0) {
            return "{}";
        }
        String bodyString = new String(bodyArray, Charset.forName("utf-8"));
        return bodyString;
    }

    private void logResponse(ResponseWrapper response, String method, String path) {
        StringBuilder responseMsg = new StringBuilder();
        String bodyString = this.getResponseBodyString(response);
        responseMsg.append("Response ").append(method).append(" ").append(path).append(" to ").append(bodyString);
        this.log.info(responseMsg.toString());
    }

    private String getResponseBodyString(ResponseWrapper response) {
        byte[] bodyArray = response.toByteArray();
        if (bodyArray == null || bodyArray.length == 0 || response.isBiggerThanIgnoreBody()) {
            return "{}";
        }
        return new String(bodyArray, Charset.forName("utf-8"));
    }

    private void logMergedRequestAndResponse(RequestWrapper request, ResponseWrapper response, String method, String path) {
        String requestBodyString = this.getRequestBodyString(request);
        String responseBodyString = this.getResponseBodyString(response);
        StringBuilder sb = new StringBuilder();
        sb.append("Response ").append(method).append(" ").append(path).append(" for ").append(requestBodyString).append(" to ").append(responseBodyString);
        this.log.info(sb.toString());
    }

    private void logTotalTime(RequestWrapper request, String method, String path, long last) {
        String requestBodyString = this.getRequestBodyString(request);
        StringBuilder totalTimeMsg = new StringBuilder();
        long total = System.currentTimeMillis() - last;
        totalTimeMsg.append("TotalTime ").append(total).append(" ms ").append("Request ").append(method).append(" ").append(path).append(" for ").append(requestBodyString);
        this.log.info(totalTimeMsg.toString());
    }

    private boolean isBinaryContent(HttpServletRequest request) {
        if (request.getContentType() == null) {
            return false;
        }
        return request.getContentType().startsWith("image") || request.getContentType().startsWith("video") || request.getContentType().startsWith("audio");
    }

    private boolean isMultipart(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().startsWith("multipart/form-data");
    }

    public void destroy() {
    }
}

