package com.uccc.commons.logging;

import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Created by kidbei on 2016/12/14.
 */
public class ResponseWrapper extends HttpServletResponseWrapper implements LoggerWrapper{

    private long        ignoreBodySize = IGNORE_BODY_SIZE;
    private ByteArrayOutputStream   out = new ByteArrayOutputStream();
    private PrintWriter writer = new PrintWriter(out);


    public ResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ResponseWrapper(HttpServletResponse response, long ignoreBodySize) {
        super(response);
        this.ignoreBodySize = ignoreBodySize;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return new TeePrintWriter(super.getWriter(), writer);
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream() {
            @Override
            public boolean isReady() {
                return false;
            }

            @Override
            public void setWriteListener(WriteListener writeListener) {

            }

            private OutputStream sourceOut = ResponseWrapper.super.getOutputStream();

            @Override
            public void write(int b) throws IOException {
                sourceOut.write(b);
                out.write(b);
            }
        };
    }

    @Override
    public long getIgnoreBodySize() {
        return ignoreBodySize;
    }

    @Override
    public ByteArrayOutputStream getOut() {
        return out;
    }

    public void setIgnoreBodySize(long ignoreBodySize) {
        this.ignoreBodySize = ignoreBodySize;
    }
}
